/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control.developer;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.model.Laser;
import java.awt.Font;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LaserDeveloperPanel
extends JPanel
implements Observer {
    private Laser _laser;
    private LinearValueControl _trapForceRatioControl;
    private LinearValueControl _electricFieldScaleControl;

    public LaserDeveloperPanel(Font font, Font font2, Laser laser) {
        this._laser = laser;
        this._laser.addObserver(this);
        TitledBorder titledBorder = new TitledBorder("Laser");
        titledBorder.setTitleFont(font);
        this.setBorder(titledBorder);
        double d = laser.getTrapForceRatioRange().getMin();
        double d2 = laser.getTrapForceRatioRange().getMax();
        this._trapForceRatioControl = new LinearValueControl(d, d2, "<html>F<sub>z</sub>/F<sub>x</sub>&nbsp;=</html>", "0.000", "");
        this._trapForceRatioControl.setTextFieldColumns(4);
        this._trapForceRatioControl.setFont(font2);
        this._trapForceRatioControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LaserDeveloperPanel.this.handleTrapForceRatioControl();
            }
        });
        d = laser.getElectricFieldScaleRange().getMin();
        d2 = laser.getElectricFieldScaleRange().getMax();
        this._electricFieldScaleControl = new LinearValueControl(d, d2, "E-field scale:", "0.00", "");
        this._electricFieldScaleControl.setTextFieldColumns(4);
        this._electricFieldScaleControl.setFont(font2);
        this._electricFieldScaleControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LaserDeveloperPanel.this.handleElectricFieldScaleControl();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._trapForceRatioControl, n++, n2);
        easyGridBagLayout.addComponent(this._electricFieldScaleControl, n++, n2);
        this._trapForceRatioControl.setValue(this._laser.getTrapForceRatio());
        this._electricFieldScaleControl.setValue(this._laser.getElectricFieldScale());
    }

    private void handleTrapForceRatioControl() {
        double d = this._trapForceRatioControl.getValue();
        this._laser.deleteObserver(this);
        this._laser.setTrapForceRatio(d);
        this._laser.addObserver(this);
    }

    private void handleElectricFieldScaleControl() {
        double d = this._electricFieldScaleControl.getValue();
        this._laser.deleteObserver(this);
        this._laser.setElectricFieldScale(d);
        this._laser.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._laser) {
            if (object == "trapForceRatio") {
                this._trapForceRatioControl.setValue(this._laser.getTrapForceRatio());
            } else if (object == "electricFieldScale") {
                this._electricFieldScaleControl.setValue(this._laser.getElectricFieldScale());
            }
        }
    }
}

