/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control.developer;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.control.developer.BeadDeveloperPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DNAStrandDeveloperPanel;
import edu.colorado.phet.opticaltweezers.control.developer.LaserDeveloperPanel;
import edu.colorado.phet.opticaltweezers.control.developer.VectorsDeveloperPanel;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.view.ChargeDistributionNode;
import edu.colorado.phet.opticaltweezers.view.DNAForceNode;
import edu.colorado.phet.opticaltweezers.view.DNAStrandNode;
import edu.colorado.phet.opticaltweezers.view.ElectricFieldNode;
import edu.colorado.phet.opticaltweezers.view.FluidDragForceNode;
import edu.colorado.phet.opticaltweezers.view.TrapForceNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DeveloperControlPanel
extends JPanel {
    private JButton _showHideButton = new JButton();
    private Box _panel;
    private BeadDeveloperPanel _beadPanel;
    private VectorsDeveloperPanel _vectorsPanel;

    public DeveloperControlPanel(Font font, Font font2, Frame frame, OTClock oTClock, Bead bead, Bead bead2, Laser laser, DNAStrand dNAStrand, DNAStrandNode dNAStrandNode, DNAStrand dNAStrand2, DNAStrandNode dNAStrandNode2, TrapForceNode trapForceNode, FluidDragForceNode fluidDragForceNode, DNAForceNode dNAForceNode, ElectricFieldNode electricFieldNode, ChargeDistributionNode chargeDistributionNode, boolean bl) {
        JPanel jPanel;
        this._showHideButton.setFont(font);
        this._showHideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeveloperControlPanel.this.handleShowHideButton();
            }
        });
        this._panel = new Box(1);
        this._vectorsPanel = new VectorsDeveloperPanel(font, font2, trapForceNode, fluidDragForceNode, dNAForceNode, electricFieldNode);
        this._panel.add(this._vectorsPanel);
        LaserDeveloperPanel laserDeveloperPanel = new LaserDeveloperPanel(font, font2, laser);
        this._panel.add(laserDeveloperPanel);
        this._beadPanel = new BeadDeveloperPanel("Bead", font, font2, oTClock, bead, laser, chargeDistributionNode, bl);
        this._panel.add(this._beadPanel);
        if (bead2 != null) {
            jPanel = new BeadDeveloperPanel("Bead (invisible, DNA free end)", font, font2, oTClock, bead2, null, null, bl);
            this._panel.add(jPanel);
        }
        if (dNAStrand != null) {
            jPanel = new DNAStrandDeveloperPanel("DNA strand (bead attached)", font, font2, dNAStrand, dNAStrandNode);
            this._panel.add(jPanel);
        }
        if (dNAStrand2 != null) {
            jPanel = new DNAStrandDeveloperPanel("DNA strand (free end)", font, font2, dNAStrand2, dNAStrandNode2);
            this._panel.add(jPanel);
        }
        jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        easyGridBagLayout.setMinimumWidth(0, 0);
        int n = 0;
        easyGridBagLayout.addComponent(this._showHideButton, n++, 1);
        easyGridBagLayout.addComponent(this._panel, n++, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this._showHideButton.setText("Developer Controls >>");
        this._panel.setVisible(false);
    }

    public VectorsDeveloperPanel getVectorsPanel() {
        return this._vectorsPanel;
    }

    public BeadDeveloperPanel getBeadPanel() {
        return this._beadPanel;
    }

    private void handleShowHideButton() {
        this._panel.setVisible(!this._panel.isVisible());
        if (this._panel.isVisible()) {
            this._showHideButton.setText("Developer Controls <<");
        } else {
            this._showHideButton.setText("Developer Controls >>");
        }
    }
}

