/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control.developer;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.view.DNAStrandNode;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DNAStrandDeveloperPanel
extends JPanel
implements PropertyChangeListener,
Observer {
    private DNAStrand _dnaStrand;
    private DNAStrandNode _dnaStrandNode;
    private JCheckBox _pivotsCheckBox;
    private JCheckBox _extensionCheckBox;
    private LinearValueControl _springConstantControl;
    private LinearValueControl _dragCoefficientControl;
    private LinearValueControl _kickConstant;
    private LinearValueControl _numberOfEvolutionsPerClockTickControl;
    private LinearValueControl _evolutionDtControl;
    private LinearValueControl _fluidDragCoefficientControl;

    public DNAStrandDeveloperPanel(String string, Font font, Font font2, DNAStrand dNAStrand, DNAStrandNode dNAStrandNode) {
        this._dnaStrand = dNAStrand;
        this._dnaStrand.addObserver(this);
        this._dnaStrandNode = dNAStrandNode;
        this._dnaStrandNode.addPropertyChangeListener(this);
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setTitleFont(font);
        this.setBorder(titledBorder);
        this._pivotsCheckBox = new JCheckBox("Show pivots");
        this._pivotsCheckBox.setFont(font2);
        this._pivotsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNAStrandDeveloperPanel.this.handlePivotsCheckBox();
            }
        });
        this._extensionCheckBox = new JCheckBox("Show extension");
        this._extensionCheckBox.setFont(font2);
        this._extensionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNAStrandDeveloperPanel.this.handleExtensionCheckBox();
            }
        });
        double d = dNAStrand.getSpringConstantRange().getMin();
        double d2 = dNAStrand.getSpringConstantRange().getMax();
        this._springConstantControl = new LinearValueControl(d, d2, "k/m:", "#0.0", "(spring)");
        this._springConstantControl.setUpDownArrowDelta(0.1);
        this._springConstantControl.setFont(font2);
        this._springConstantControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleSpringConstantControl();
            }
        });
        d = dNAStrand.getDragCoefficientRange().getMin();
        d2 = dNAStrand.getDragCoefficientRange().getMax();
        this._dragCoefficientControl = new LinearValueControl(d, d2, "b:", "0.0", "(damping)");
        this._dragCoefficientControl.setUpDownArrowDelta(0.1);
        this._dragCoefficientControl.setFont(font2);
        this._dragCoefficientControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleDampingConstantControl();
            }
        });
        d = dNAStrand.getEvolutionDtRange().getMin();
        d2 = dNAStrand.getEvolutionDtRange().getMax();
        this._evolutionDtControl = new LinearValueControl(d, d2, "dt:", "0.00", "");
        this._evolutionDtControl.setUpDownArrowDelta(0.01);
        this._evolutionDtControl.setFont(font2);
        this._evolutionDtControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleEvolutionDtScaleControl();
            }
        });
        d = dNAStrand.getKickConstantRange().getMin();
        d2 = dNAStrand.getKickConstantRange().getMax();
        this._kickConstant = new LinearValueControl(d, d2, "kick:", "##0", "");
        this._kickConstant.setUpDownArrowDelta(1.0);
        this._kickConstant.setFont(font2);
        this._kickConstant.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleKickControl();
            }
        });
        d = dNAStrand.getNumberOfEvolutionsPerClockTickRange().getMin();
        d2 = dNAStrand.getNumberOfEvolutionsPerClockTickRange().getMax();
        this._numberOfEvolutionsPerClockTickControl = new LinearValueControl(d, d2, "evolutions:", "##0", "");
        this._numberOfEvolutionsPerClockTickControl.setUpDownArrowDelta(1.0);
        this._numberOfEvolutionsPerClockTickControl.setFont(font2);
        this._numberOfEvolutionsPerClockTickControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleNumberOfEvolutionsPerClockTickControl();
            }
        });
        d = dNAStrand.getFluidDragCoefficientRange().getMin();
        d2 = dNAStrand.getFluidDragCoefficientRange().getMax();
        this._fluidDragCoefficientControl = new LinearValueControl(d, d2, "fluid drag coeff:", "0.000000", "");
        this._fluidDragCoefficientControl.setUpDownArrowDelta(0.1);
        this._fluidDragCoefficientControl.setFont(font2);
        this._fluidDragCoefficientControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DNAStrandDeveloperPanel.this.handleFluidDragCoefficientControl();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._pivotsCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._extensionCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._springConstantControl, n++, n2);
        easyGridBagLayout.addComponent(this._dragCoefficientControl, n++, n2);
        easyGridBagLayout.addComponent(this._evolutionDtControl, n++, n2);
        easyGridBagLayout.addComponent(this._kickConstant, n++, n2);
        easyGridBagLayout.addComponent(this._numberOfEvolutionsPerClockTickControl, n++, n2);
        easyGridBagLayout.addComponent(this._fluidDragCoefficientControl, n++, n2);
        this._pivotsCheckBox.setSelected(this._dnaStrandNode.isPivotsVisible());
        this._extensionCheckBox.setSelected(this._dnaStrandNode.isExtensionVisible());
        this._springConstantControl.setValue(this._dnaStrand.getSpringConstant());
        this._dragCoefficientControl.setValue(this._dnaStrand.getDragCoefficient());
        this._kickConstant.setValue(this._dnaStrand.getKickConstant());
        this._numberOfEvolutionsPerClockTickControl.setValue(this._dnaStrand.getNumberOfEvolutionsPerClockTick());
        this._evolutionDtControl.setValue(this._dnaStrand.getEvolutionDt());
        this._fluidDragCoefficientControl.setValue(this._dnaStrand.getFluidDragCoefficient());
    }

    private void handlePivotsCheckBox() {
        this._dnaStrandNode.setPivotsVisible(this._pivotsCheckBox.isSelected());
    }

    private void handleExtensionCheckBox() {
        this._dnaStrandNode.setExtensionVisible(this._extensionCheckBox.isSelected());
    }

    private void handleSpringConstantControl() {
        double d = this._springConstantControl.getValue();
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setSpringConstant(d);
        this._dnaStrand.addObserver(this);
    }

    private void handleDampingConstantControl() {
        double d = this._dragCoefficientControl.getValue();
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setDragCoefficient(d);
        this._dnaStrand.addObserver(this);
    }

    private void handleKickControl() {
        double d = this._kickConstant.getValue();
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setKickConstant(d);
        this._dnaStrand.addObserver(this);
    }

    private void handleNumberOfEvolutionsPerClockTickControl() {
        int n = (int)Math.round(this._numberOfEvolutionsPerClockTickControl.getValue());
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setNumberOfEvolutionsPerClockTick(n);
        this._dnaStrand.addObserver(this);
    }

    private void handleEvolutionDtScaleControl() {
        double d = this._evolutionDtControl.getValue();
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setEvolutionDt(d);
        this._dnaStrand.addObserver(this);
    }

    private void handleFluidDragCoefficientControl() {
        double d = this._fluidDragCoefficientControl.getValue();
        this._dnaStrand.deleteObserver(this);
        this._dnaStrand.setFluidDragCoefficient(d);
        this._dnaStrand.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._dnaStrand) {
            if (object == "springConstant") {
                this._springConstantControl.setValue(this._dnaStrand.getSpringConstant());
            } else if (object == "dragCoefficient") {
                this._dragCoefficientControl.setValue(this._dnaStrand.getDragCoefficient());
            } else if (object == "kickConstant") {
                this._kickConstant.setValue(this._dnaStrand.getKickConstant());
            } else if (object == "numberOfEvolutionsPerClockTick") {
                this._numberOfEvolutionsPerClockTickControl.setValue(this._dnaStrand.getNumberOfEvolutionsPerClockTick());
            } else if (object == "evolutionDtScale") {
                this._evolutionDtControl.setValue(this._dnaStrand.getEvolutionDt());
            } else if (object == "fluidDragCoefficient") {
                this._fluidDragCoefficientControl.setValue(this._dnaStrand.getFluidDragCoefficient());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this._dnaStrandNode) {
            if (propertyChangeEvent.getPropertyName() == "pivotsVisible") {
                this._pivotsCheckBox.setSelected(this._dnaStrandNode.isPivotsVisible());
            } else if (propertyChangeEvent.getPropertyName() == "extensionVisible") {
                this._extensionCheckBox.setSelected(this._dnaStrandNode.isExtensionVisible());
            }
        }
    }
}

