/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control.developer;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.view.ChargeDistributionNode;
import java.awt.Color;
import java.awt.Font;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BeadDeveloperPanel
extends JPanel
implements ConstantDtClock.ConstantDtClockListener,
Observer {
    private OTClock _clock;
    private Bead _bead;
    private Laser _laser;
    private ChargeDistributionNode _chargeDistributionNode;
    private LinearValueControl _brownianMotionScaleControl;
    private LogarithmicValueControl _dtSubdivisionThresholdControl;
    private LinearValueControl _numberOfDtSubdivisions;
    private LogarithmicValueControl _verletDtSubdivisionThresholdControl;
    private LinearValueControl _verletNumberOfDtSubdivisions;
    private LogarithmicValueControl _verletMotionScaleControl;
    private LogarithmicValueControl _vacuumFastThresholdControl;
    private LogarithmicValueControl _vacuumFastDtControl;
    private LinearValueControl _vacuumFastPowerControl;
    private LinearValueControl _chargeMotionScaleControl;

    public BeadDeveloperPanel(String string, Font font, Font font2, OTClock oTClock, Bead bead, Laser laser, ChargeDistributionNode chargeDistributionNode, boolean bl) {
        this._clock = oTClock;
        this._clock.addConstantDtClockListener(this);
        this._bead = bead;
        this._bead.addObserver(this);
        this._laser = laser;
        if (this._laser != null) {
            this._laser.addObserver(this);
        }
        this._chargeDistributionNode = chargeDistributionNode;
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setTitleFont(font);
        this.setBorder(titledBorder);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        double d = bead.getBrownianMotionScaleRange().getMin();
        double d2 = bead.getBrownianMotionScaleRange().getMax();
        this._brownianMotionScaleControl = new LinearValueControl(d, d2, "Brownian scale:", "0.0", "");
        this._brownianMotionScaleControl.setUpDownArrowDelta(0.1);
        this._brownianMotionScaleControl.setFont(font2);
        this._brownianMotionScaleControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BeadDeveloperPanel.this.handleBrownianMotionScaleControl();
            }
        });
        this._brownianMotionScaleControl.setValue(this._bead.getBrownianMotionScale());
        easyGridBagLayout.addComponent(this._brownianMotionScaleControl, n++, n2);
        d = bead.getNumberOfDtSubdivisionsRange().getMin();
        d2 = bead.getNumberOfDtSubdivisionsRange().getMax();
        this._numberOfDtSubdivisions = new LinearValueControl(d, d2, "# dt subdivisions:", "###0", "");
        this._numberOfDtSubdivisions.setUpDownArrowDelta(1.0);
        this._numberOfDtSubdivisions.setFont(font2);
        this._numberOfDtSubdivisions.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BeadDeveloperPanel.this.handleNumberOfDtDubdivisionsControl();
            }
        });
        this._numberOfDtSubdivisions.setValue(this._bead.getNumberOfDtSubdivisions());
        easyGridBagLayout.addComponent(this._numberOfDtSubdivisions, n++, n2);
        d = bead.getDtSubdivisionThresholdRange().getMin();
        d2 = bead.getDtSubdivisionThresholdRange().getMax();
        this._dtSubdivisionThresholdControl = new LogarithmicValueControl(d, d2, "subdivision threshold:", "0.0E0", "");
        this._dtSubdivisionThresholdControl.setTextFieldColumns(4);
        this._dtSubdivisionThresholdControl.setFont(font2);
        this._dtSubdivisionThresholdControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BeadDeveloperPanel.this.handleDtDubdivisionThresholdControl();
            }
        });
        this._dtSubdivisionThresholdControl.setValue(this._bead.getDtSubdivisionThreshold());
        easyGridBagLayout.addComponent(this._dtSubdivisionThresholdControl, n++, n2);
        if (bl) {
            d = bead.getVerletNumberOfDtSubdivisionsRange().getMin();
            d2 = bead.getVerletNumberOfDtSubdivisionsRange().getMax();
            this._verletNumberOfDtSubdivisions = new LinearValueControl(d, d2, "Verlet # dt subdivisions:", "###0", "");
            this._verletNumberOfDtSubdivisions.setUpDownArrowDelta(1.0);
            this._verletNumberOfDtSubdivisions.setFont(font2);
            this._verletNumberOfDtSubdivisions.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVerletNumberOfDtDubdivisionsControl();
                }
            });
            this._verletNumberOfDtSubdivisions.setValue(this._bead.getVerletNumberOfDtSubdivisions());
            easyGridBagLayout.addComponent(this._verletNumberOfDtSubdivisions, n++, n2);
            d = bead.getVerletDtSubdivisionThresholdRange().getMin();
            d2 = bead.getVerletDtSubdivisionThresholdRange().getMax();
            this._verletDtSubdivisionThresholdControl = new LogarithmicValueControl(d, d2, "Verlet subdivision threshold:", "0.0E0", "");
            this._verletDtSubdivisionThresholdControl.setTextFieldColumns(4);
            this._verletDtSubdivisionThresholdControl.setFont(font2);
            this._verletDtSubdivisionThresholdControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVerletDtDubdivisionThresholdControl();
                }
            });
            this._verletDtSubdivisionThresholdControl.setValue(this._bead.getVerletDtSubdivisionThreshold());
            easyGridBagLayout.addComponent(this._verletDtSubdivisionThresholdControl, n++, n2);
            d = bead.getVerletAccelerationScaleRange().getMin();
            d2 = bead.getVerletAccelerationScaleRange().getMax();
            this._verletMotionScaleControl = new LogarithmicValueControl(d, d2, "Verlet scale:", "0.0E0", "");
            this._verletMotionScaleControl.setUpDownArrowDelta(1.0E-9);
            this._verletMotionScaleControl.setFont(font2);
            this._verletMotionScaleControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVerletAccelerationScaleControl();
                }
            });
            this._verletMotionScaleControl.setValue(this._bead.getVerletAccelerationScale());
            easyGridBagLayout.addComponent(this._verletMotionScaleControl, n++, n2);
            d = bead.getVacuumFastThresholdRange().getMin();
            d2 = bead.getVacuumFastThresholdRange().getMax();
            this._vacuumFastThresholdControl = new LogarithmicValueControl(d, d2, "vacuum fast threshold:", "0.0E0", "");
            this._vacuumFastThresholdControl.setUpDownArrowDelta(1.0E-9);
            this._vacuumFastThresholdControl.setFont(font2);
            this._vacuumFastThresholdControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVacuumFastThresholdControl();
                }
            });
            this._vacuumFastThresholdControl.setValue(this._bead.getVacuumFastThreshold());
            this.updateVaccumFastThresholdIndicator();
            easyGridBagLayout.addComponent(this._vacuumFastThresholdControl, n++, n2);
            d = bead.getVacuumFastDtRange().getMin();
            d2 = bead.getVacuumFastDtRange().getMax();
            this._vacuumFastDtControl = new LogarithmicValueControl(d, d2, "vacuum fast dt:", "0.0E0", "");
            this._vacuumFastDtControl.setUpDownArrowDelta(1.0E-9);
            this._vacuumFastDtControl.setFont(font2);
            this._vacuumFastDtControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVacuumFastDtControl();
                }
            });
            this._vacuumFastDtControl.setValue(this._bead.getVacuumFastDt());
            easyGridBagLayout.addComponent(this._vacuumFastDtControl, n++, n2);
            d = bead.getVacuumFastPowerRange().getMin();
            d2 = bead.getVacuumFastPowerRange().getMax();
            this._vacuumFastPowerControl = new LinearValueControl(d, d2, "vacuum fast power:", "##0", "mW");
            this._vacuumFastPowerControl.setUpDownArrowDelta(1.0);
            this._vacuumFastPowerControl.setFont(font2);
            this._vacuumFastPowerControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleVacuumFastPowerControl();
                }
            });
            this._vacuumFastPowerControl.setValue(this._bead.getVacuumFastPower());
            easyGridBagLayout.addComponent(this._vacuumFastPowerControl, n++, n2);
        }
        if (chargeDistributionNode != null) {
            d = chargeDistributionNode.getChargeMotionScaleRange().getMin();
            d2 = chargeDistributionNode.getChargeMotionScaleRange().getMax();
            this._chargeMotionScaleControl = new LinearValueControl(d, d2, "charge motion scale:", "0.00", "");
            this._chargeMotionScaleControl.setUpDownArrowDelta(0.01);
            this._chargeMotionScaleControl.setFont(font2);
            this._chargeMotionScaleControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BeadDeveloperPanel.this.handleChargeMotionScaleControl();
                }
            });
            this._chargeMotionScaleControl.setValue(this._chargeDistributionNode.getChargeMotionScale());
            easyGridBagLayout.addComponent(this._chargeMotionScaleControl, n++, n2);
        }
    }

    public void setChargeMotionScale(double d) {
        this._chargeMotionScaleControl.setValue(d);
        this.handleChargeMotionScaleControl();
    }

    private void handleBrownianMotionScaleControl() {
        double d = this._brownianMotionScaleControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setBrownianMotionScale(d);
        this._bead.addObserver(this);
    }

    private void handleDtDubdivisionThresholdControl() {
        double d = this._dtSubdivisionThresholdControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setDtSubdivisionThreshold(d);
        this._bead.addObserver(this);
    }

    private void handleNumberOfDtDubdivisionsControl() {
        int n = (int)Math.round(this._numberOfDtSubdivisions.getValue());
        this._bead.deleteObserver(this);
        this._bead.setNumberOfDtSubdivisions(n);
        this._bead.addObserver(this);
    }

    private void handleVerletDtDubdivisionThresholdControl() {
        double d = this._verletDtSubdivisionThresholdControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setVerletDtSubdivisionThreshold(d);
        this._bead.addObserver(this);
    }

    private void handleVerletNumberOfDtDubdivisionsControl() {
        int n = (int)Math.round(this._verletNumberOfDtSubdivisions.getValue());
        this._bead.deleteObserver(this);
        this._bead.setVerletNumberOfDtSubdivisions(n);
        this._bead.addObserver(this);
    }

    private void handleVerletAccelerationScaleControl() {
        double d = this._verletMotionScaleControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setVerletAccelerationScale(d);
        this._bead.addObserver(this);
    }

    private void handleVacuumFastThresholdControl() {
        double d = this._vacuumFastThresholdControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setVacuumFastThreshold(d);
        this._bead.addObserver(this);
        this.updateVaccumFastThresholdIndicator();
    }

    private void handleVacuumFastDtControl() {
        double d = this._vacuumFastDtControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setVacuumFastDt(d);
        this._bead.addObserver(this);
    }

    private void handleVacuumFastPowerControl() {
        double d = this._vacuumFastPowerControl.getValue();
        this._bead.deleteObserver(this);
        this._bead.setVacuumFastPower(d);
        this._bead.addObserver(this);
    }

    private void handleChargeMotionScaleControl() {
        double d = this._chargeMotionScaleControl.getValue();
        this._chargeDistributionNode.setChargeMotionScale(d);
    }

    private void updateVaccumFastThresholdIndicator() {
        if (this._vacuumFastThresholdControl != null) {
            if (this._clock.getDt() * this._laser.getPower() > this._vacuumFastThresholdControl.getValue()) {
                this._vacuumFastThresholdControl.getTextField().setBackground(Color.GREEN);
            } else {
                this._vacuumFastThresholdControl.getTextField().setBackground(Color.WHITE);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._bead) {
            if (object == "brownianMotionScale") {
                this._brownianMotionScaleControl.setValue(this._bead.getBrownianMotionScale());
            } else if (object == "dtSubdivisionThreshold") {
                this._dtSubdivisionThresholdControl.setValue(this._bead.getDtSubdivisionThreshold());
            } else if (object == "numberOfDtSubdivisions") {
                this._numberOfDtSubdivisions.setValue(this._bead.getNumberOfDtSubdivisions());
            } else if (object == "verletDtSubdivisionThreshold") {
                this._verletDtSubdivisionThresholdControl.setValue(this._bead.getVerletDtSubdivisionThreshold());
            } else if (object == "verletNumberOfDtSubdivisions") {
                this._verletNumberOfDtSubdivisions.setValue(this._bead.getVerletNumberOfDtSubdivisions());
            } else if (object == "verletAccelerationScale") {
                this._verletMotionScaleControl.setValue(this._bead.getVerletAccelerationScale());
            } else if (object == "vacuumFastThreshold") {
                this._vacuumFastThresholdControl.setValue(this._bead.getVacuumFastThreshold());
            } else if (object == "vacuumFastThreshold") {
                this._vacuumFastDtControl.setValue(this._bead.getVacuumFastDt());
            } else if (object == "vacuumFastThreshold") {
                this._vacuumFastPowerControl.setValue(this._bead.getVacuumFastPower());
            }
        } else if (observable == this._laser && object == "power") {
            this.updateVaccumFastThresholdIndicator();
        }
    }

    public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
        this.updateVaccumFastThresholdIndicator();
    }
}

