/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LogarithmicMappingStrategy;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SimulationSpeedSlider
extends PNode {
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Color SLOW_FILL_COLOR = new Color(180, 255, 180);
    private static final Color FAST_FILL_COLOR = new Color(50, 180, 50);
    private static final Color BETWEEN_FILL_COLOR = Color.DARK_GRAY;
    private static final Color TRACK_FILL_COLOR = Color.BLACK;
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Color KNOB_FILL_COLOR = Color.WHITE;
    private static final Color KNOB_STROKE_COLOR = Color.BLACK;
    private static final Color SLOW_LABEL_FONT_COLOR = Color.BLACK;
    private static final Color FAST_LABEL_FONT_COLOR = Color.BLACK;
    private static final Color TICK_MARK_COLOR = Color.BLACK;
    private static final Color TICK_LABEL_COLOR = Color.BLACK;
    private static final DecimalFormat TICK_LABEL_FORMAT = new DecimalFormat("0E00");
    private DoubleRange _slowRange;
    private DoubleRange _fastRange;
    private double _value;
    private PPath _trackNode;
    private PPath _knobNode;
    private EventListenerList _listenerList;
    private boolean _adjusting;
    private LogarithmicMappingStrategy _slowMappingStrategy;
    private LogarithmicMappingStrategy _fastMappingStrategy;
    private LogarithmicMappingStrategy _betweenMappingStrategy;

    public SimulationSpeedSlider(DoubleRange doubleRange, DoubleRange doubleRange2, double d) {
        if (!(doubleRange.getMax() < doubleRange2.getMin())) {
            throw new IllegalArgumentException("slowRange and fastRange overlap");
        }
        if (!doubleRange.contains(d) && !doubleRange2.contains(d)) {
            throw new IllegalArgumentException("value out of range: " + d);
        }
        this._slowRange = doubleRange;
        this._fastRange = doubleRange2;
        this._value = d;
        this._listenerList = new EventListenerList();
        this._adjusting = false;
        this._slowMappingStrategy = new LogarithmicMappingStrategy(this._slowRange.getMin(), this._slowRange.getMax(), 0, 75);
        this._fastMappingStrategy = new LogarithmicMappingStrategy(this._fastRange.getMin(), this._fastRange.getMax(), 0, 75);
        this._betweenMappingStrategy = new LogarithmicMappingStrategy(this._slowRange.getMax(), this._fastRange.getMin(), 0, 15);
        this.initNodes();
        this.initInteractivity();
        this.updateKnobPosition();
    }

    private void initNodes() {
        String string = OTResources.getString("label.slow");
        String string2 = OTResources.getString("label.fast");
        PText pText = new PText(string);
        pText.setFont(new PhetFont(12));
        pText.setTextPaint(SLOW_LABEL_FONT_COLOR);
        PText pText2 = new PText(string2);
        pText2.setFont(new PhetFont(12));
        pText2.setTextPaint(FAST_LABEL_FONT_COLOR);
        PPath pPath = SimulationSpeedSlider.createBackgroundNode(75, SLOW_FILL_COLOR);
        PPath pPath2 = SimulationSpeedSlider.createBackgroundNode(75, FAST_FILL_COLOR);
        PPath pPath3 = SimulationSpeedSlider.createBackgroundNode(15, BETWEEN_FILL_COLOR);
        this._trackNode = SimulationSpeedSlider.createTrackNode();
        this._knobNode = SimulationSpeedSlider.createKnobNode();
        PPath pPath4 = SimulationSpeedSlider.createTickMarkNode();
        PPath pPath5 = SimulationSpeedSlider.createTickMarkNode();
        PPath pPath6 = SimulationSpeedSlider.createTickMarkNode();
        PPath pPath7 = SimulationSpeedSlider.createTickMarkNode();
        PText pText3 = SimulationSpeedSlider.createTickLabelNode(this._slowRange.getMin());
        PText pText4 = SimulationSpeedSlider.createTickLabelNode(this._slowRange.getMax());
        PText pText5 = SimulationSpeedSlider.createTickLabelNode(this._fastRange.getMin());
        PText pText6 = SimulationSpeedSlider.createTickLabelNode(this._fastRange.getMax());
        double d = 0.0;
        double d2 = 0.0;
        pPath.setOffset(d, d2);
        d = 75.0;
        d2 = pPath.getYOffset();
        pPath3.setOffset(d, d2);
        d = 90.0;
        d2 = pPath3.getYOffset();
        pPath2.setOffset(d, d2);
        d = pPath.getXOffset() + (pPath.getFullBounds().getWidth() - pText.getFullBounds().getWidth()) / 2.0;
        d2 = -(pText.getFullBounds().getHeight() + 5.0);
        pText.setOffset(d, d2);
        d = pPath2.getXOffset() + (pPath2.getFullBounds().getWidth() - pText2.getFullBounds().getWidth()) / 2.0;
        d2 = -(pText2.getFullBounds().getHeight() + 5.0);
        pText2.setOffset(d, d2);
        d = pPath.getXOffset();
        d2 = pPath.getYOffset() + (20.0 - this._trackNode.getFullBounds().getHeight()) / 2.0;
        this._trackNode.setOffset(d, d2);
        d = pPath.getXOffset() - this._knobNode.getFullBounds().getWidth() / 2.0;
        d2 = pPath.getYOffset() + (20.0 - this._knobNode.getFullBounds().getHeight()) / 2.0;
        this._knobNode.setOffset(d, d2);
        d = pPath.getXOffset();
        d2 = pPath.getFullBounds().getMaxY();
        pPath4.setOffset(d, d2);
        d = pPath.getFullBounds().getMaxX();
        pPath5.setOffset(d, d2);
        d = pPath2.getXOffset();
        d2 = pPath2.getFullBounds().getMaxY();
        pPath6.setOffset(d, d2);
        d = pPath2.getFullBounds().getMaxX() - pPath7.getFullBounds().getWidth();
        pPath7.setOffset(d, d2);
        d = pPath4.getXOffset() - pText3.getFullBounds().getWidth() / 2.0;
        d2 = pPath4.getFullBounds().getMaxY() + 2.0;
        pText3.setOffset(d, d2);
        d = pPath5.getXOffset() - pText4.getFullBounds().getWidth();
        d2 = pPath5.getFullBounds().getMaxY() + 2.0;
        pText4.setOffset(d, d2);
        d = pPath6.getXOffset();
        d2 = pPath6.getFullBounds().getMaxY() + 2.0;
        pText5.setOffset(d, d2);
        d = pPath7.getXOffset() - pText6.getFullBounds().getWidth() / 2.0;
        d2 = pPath7.getFullBounds().getMaxY() + 2.0;
        pText6.setOffset(d, d2);
        this.addChild(pPath4);
        this.addChild(pPath5);
        this.addChild(pPath6);
        this.addChild(pPath7);
        this.addChild(pText3);
        this.addChild(pText4);
        this.addChild(pText5);
        this.addChild(pText6);
        this.addChild(pPath3);
        this.addChild(pPath);
        this.addChild(pPath2);
        this.addChild(pText);
        this.addChild(pText2);
        this.addChild(this._trackNode);
        this.addChild(this._knobNode);
        pText.setPickable(false);
        pText2.setPickable(false);
        pPath.setPickable(false);
        pPath2.setPickable(false);
        pPath3.setPickable(false);
        this._trackNode.setPickable(true);
        this._knobNode.setPickable(true);
        pPath4.setPickable(false);
        pPath5.setPickable(false);
        pPath6.setPickable(false);
        pPath7.setPickable(false);
        pText3.setPickable(false);
        pText4.setPickable(false);
        pText5.setPickable(false);
        pText6.setPickable(false);
    }

    private static PPath createBackgroundNode(int n, Paint paint) {
        int n2 = n - 1;
        int n3 = 19;
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        PPath pPath = new PPath(rectangle);
        pPath.setPaint(paint);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(BACKGROUND_STROKE_COLOR);
        return pPath;
    }

    private static PPath createTrackNode() {
        int n = 164;
        int n2 = Math.max(1, 1);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        PPath pPath = new PPath(rectangle);
        pPath.setPaint(TRACK_FILL_COLOR);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(TRACK_STROKE_COLOR);
        return pPath;
    }

    private static PPath createKnobNode() {
        float f = 14.0f;
        float f2 = 15.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(f, 0.0f);
        generalPath.lineTo(f, 0.65f * f2);
        generalPath.lineTo(f / 2.0f, f2);
        generalPath.lineTo(0.0f, 0.65f * f2);
        generalPath.closePath();
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(KNOB_FILL_COLOR);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(KNOB_STROKE_COLOR);
        return pPath;
    }

    private static PPath createTickMarkNode() {
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, 10.0);
        PPath pPath = new PPath(double_);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(TICK_MARK_COLOR);
        return pPath;
    }

    private static PText createTickLabelNode(double d) {
        PText pText = new PText();
        pText.setText(TICK_LABEL_FORMAT.format(d));
        pText.setFont(new PhetFont(10));
        pText.setTextPaint(TICK_LABEL_COLOR);
        return pText;
    }

    private void initInteractivity() {
        double d = this._trackNode.getFullBounds().getX() - this._knobNode.getFullBounds().getWidth() / 2.0;
        double d2 = this._trackNode.getFullBounds().getMaxX() + this._knobNode.getFullBounds().getWidth() / 2.0;
        double d3 = this._trackNode.getFullBounds().getY() + this._trackNode.getFullBounds().getHeight() / 2.0 - this._knobNode.getFullBounds().getHeight() / 2.0;
        double d4 = this._trackNode.getFullBounds().getY() + this._trackNode.getFullBounds().getHeight() / 2.0 + this._knobNode.getFullBounds().getHeight() / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        PPath pPath = new PPath(double_);
        pPath.setStroke(null);
        this.addChild(pPath);
        BoundedDragHandler boundedDragHandler = new BoundedDragHandler(this._knobNode, pPath);
        this._knobNode.addInputEventListener(boundedDragHandler);
        this._knobNode.addInputEventListener(new CursorHandler());
        this._knobNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("transform") && SimulationSpeedSlider.this._adjusting) {
                    SimulationSpeedSlider.this.updateValue();
                }
            }
        });
        this._knobNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                SimulationSpeedSlider.this._adjusting = true;
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                SimulationSpeedSlider.this._adjusting = false;
                SimulationSpeedSlider.this.snapToClosest();
                SimulationSpeedSlider.this.fireChangeEvent(new ChangeEvent(this));
            }
        });
    }

    public DoubleRange getSlowRange() {
        return this._slowRange;
    }

    public DoubleRange getFastRange() {
        return this._fastRange;
    }

    public boolean isInBetween() {
        return this._value > this._slowRange.getMax() && this._value < this._fastRange.getMin();
    }

    public void setValue(double d) {
        if (d < this._slowRange.getMin() || d > this._fastRange.getMax()) {
            throw new IllegalArgumentException("value out of range: " + d);
        }
        if (d != this._value) {
            this._value = d;
            this.updateKnobPosition();
            this.snapToClosest();
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public double getValue() {
        return this._value;
    }

    private void setSliderValue(int n) {
        this._knobNode.setOffset((double)n - this._knobNode.getFullBounds().getWidth() / 2.0, this._knobNode.getYOffset());
    }

    private int getSliderValue() {
        int n = (int)(this._knobNode.getXOffset() + this._knobNode.getFullBounds().getWidth() / 2.0);
        if (n < 0) {
            n = 0;
        } else if (n > 165) {
            n = 165;
        }
        return n;
    }

    private boolean isKnobInSlowRange(int n) {
        return n >= 0 && n <= 75;
    }

    private boolean isKnobInBetweenRange(int n) {
        return n > 75 && n <= 90;
    }

    private boolean isKnobInFastRange(int n) {
        return n > 90 && n <= 165;
    }

    private void updateValue() {
        int n = this.getSliderValue();
        if (this.isKnobInSlowRange(n)) {
            this._value = this._slowMappingStrategy.sliderToModel(n);
        } else if (this.isKnobInBetweenRange(n)) {
            this._value = this._betweenMappingStrategy.sliderToModel(n - 75);
        } else if (this.isKnobInFastRange(n)) {
            this._value = this._fastMappingStrategy.sliderToModel(n - 75 - 15);
        } else {
            throw new IllegalStateException("knob is out of range, programming error?");
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    private void updateKnobPosition() {
        int n = 0;
        n = this._value <= this._slowRange.getMax() ? this._slowMappingStrategy.modelToSlider(this._value) : (this._value < this._fastRange.getMin() ? 75 + this._betweenMappingStrategy.modelToSlider(this._value) : 90 + this._fastMappingStrategy.modelToSlider(this._value));
        this.setSliderValue(n);
    }

    private void snapToClosest() {
        int n = this.getSliderValue();
        if (this.isKnobInBetweenRange(n)) {
            if (n - 75 < 7) {
                this.setValue(this._slowRange.getMax());
            } else {
                this.setValue(this._fastRange.getMin());
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

