/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.control.SimulationSpeedSlider;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulationSpeedControlPanel
extends JPanel {
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("0.0E00");
    private static final int VALUE_COLUMNS = "0.0E00".length();
    private OTClock _clock;
    private SimulationSpeedSlider _slider;
    private JFormattedTextField _textField;

    public SimulationSpeedControlPanel(Font font, Font font2, OTClock oTClock) {
        this._clock = oTClock;
        this._clock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
            }
        });
        JLabel jLabel = new JLabel(OTResources.getString("label.simulationSpeed"));
        jLabel.setFont(font);
        this._slider = new SimulationSpeedSlider(oTClock.getSlowRange(), oTClock.getFastRange(), oTClock.getDt());
        this._slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SimulationSpeedControlPanel.this.setSimulationSpeed(SimulationSpeedControlPanel.this._slider.getValue());
            }
        });
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.setBackground(this.getBackground());
        phetPCanvas.setBorder(null);
        phetPCanvas.getLayer().addChild(this._slider);
        int n = 2;
        int n2 = (int)(-this._slider.getFullBounds().getX()) + n;
        int n3 = (int)(-this._slider.getFullBounds().getY()) + n;
        this._slider.setOffset(n2, n3);
        int n4 = (int)this._slider.getFullBounds().getWidth() + 2 * n;
        int n5 = (int)this._slider.getFullBounds().getHeight() + 2 * n;
        phetPCanvas.setPreferredSize(new Dimension(n4, n5));
        this._textField = new JFormattedTextField(VALUE_FORMAT);
        this._textField.setFont(font2);
        this._textField.setValue(new Double(this._slider.getValue()));
        this._textField.setHorizontalAlignment(4);
        this._textField.setColumns(VALUE_COLUMNS);
        TextFieldListener textFieldListener = new TextFieldListener();
        this._textField.addActionListener(textFieldListener);
        this._textField.addFocusListener(textFieldListener);
        JLabel jLabel2 = new JLabel(OTResources.getString("units.time"));
        jLabel2.setFont(font2);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        int n6 = 0;
        int n7 = 0;
        easyGridBagLayout.addComponent(jLabel, n6, n7++);
        easyGridBagLayout.addComponent(this._textField, n6, n7++);
        easyGridBagLayout.addComponent(jLabel2, n6, n7++);
        n7 = 0;
        easyGridBagLayout.addComponent(phetPCanvas, ++n6, n7, 3, 1);
        this.setSimulationSpeed(oTClock.getDt());
    }

    public void setSimulationSpeed(double d) {
        if (d < this._slider.getSlowRange().getMin()) {
            d = this._slider.getSlowRange().getMin();
            Toolkit.getDefaultToolkit().beep();
        } else if (d > this._slider.getFastRange().getMax()) {
            d = this._slider.getFastRange().getMax();
            Toolkit.getDefaultToolkit().beep();
        }
        this._slider.setValue(d);
        this._textField.setValue(new Double(this._slider.getValue()));
        if (!this._slider.isInBetween()) {
            this._clock.setDt(this._slider.getValue());
        }
    }

    private double getTextFieldValue() {
        String string = this._textField.getText();
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            d = this._clock.getDt();
            this._textField.setValue(new Double(d));
        }
        return d;
    }

    private class TextFieldListener
    implements ActionListener,
    FocusListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SimulationSpeedControlPanel.this._textField) {
                SimulationSpeedControlPanel.this.setSimulationSpeed(SimulationSpeedControlPanel.this.getTextFieldValue());
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == SimulationSpeedControlPanel.this._textField) {
                SimulationSpeedControlPanel.this._textField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == SimulationSpeedControlPanel.this._textField) {
                try {
                    SimulationSpeedControlPanel.this._textField.commitEdit();
                    SimulationSpeedControlPanel.this.setSimulationSpeed(SimulationSpeedControlPanel.this.getTextFieldValue());
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                    SimulationSpeedControlPanel.this.setSimulationSpeed(SimulationSpeedControlPanel.this._slider.getValue());
                }
            }
        }
    }
}

