/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.control.LaserPowerControl;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LaserControlPanel
extends PhetPNode
implements Observer {
    private static final Stroke PANEL_STROKE = new BasicStroke(1.0f);
    private static final Color PANEL_STROKE_COLOR = Color.BLACK;
    private static final Color PANEL_FILL_COLOR = Color.DARK_GRAY;
    private static final Dimension POWER_CONTROL_SLIDER_SIZE = new Dimension(150, 25);
    private Laser _laser;
    private LaserPowerControl _powerControl;
    private PPath _backgroundNode;
    private PNode _startButton;
    private PNode _stopButton;
    private PSwing _labelWrapper;
    private PSwing _sliderWrapper;
    private PSwing _textFieldWrapper;
    private PSwing _unitsWrapper;
    private PNode _signNode;
    private ChangeListener _powerControlListener;

    public LaserControlPanel(Laser laser, Font font, double d) {
        this._laser = laser;
        this._laser.addObserver(this);
        final LaserControlPanel laserControlPanel = this;
        this._signNode = new PImage(OTResources.getImage("laserDangerSign.png"));
        this._startButton = new PImage(OTResources.getImage("laserButtonOff.png"));
        this._startButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                LaserControlPanel.this._laser.deleteObserver(laserControlPanel);
                LaserControlPanel.this._laser.setRunning(true);
                LaserControlPanel.this._laser.addObserver(laserControlPanel);
                LaserControlPanel.this.updateStartStopButton();
            }
        });
        this._stopButton = new PImage(OTResources.getImage("laserButtonOn.png"));
        this._stopButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                LaserControlPanel.this._laser.deleteObserver(laserControlPanel);
                LaserControlPanel.this._laser.setRunning(false);
                LaserControlPanel.this._laser.addObserver(laserControlPanel);
                LaserControlPanel.this.updateStartStopButton();
            }
        });
        DoubleRange doubleRange = this._laser.getPowerRange();
        String string = OTResources.getString("label.power");
        String string2 = OTResources.getString("units.power");
        double d2 = laser.getVisibleWavelength();
        this._powerControl = new LaserPowerControl(doubleRange, string, string2, "0", 4, d2, POWER_CONTROL_SLIDER_SIZE, font);
        this._powerControl.setLabelForeground(Color.WHITE);
        this._powerControl.setUnitsForeground(Color.WHITE);
        this._powerControlListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = LaserControlPanel.this._powerControl.getPower();
                LaserControlPanel.this._laser.deleteObserver(laserControlPanel);
                LaserControlPanel.this._laser.setPower(d);
                LaserControlPanel.this._laser.addObserver(laserControlPanel);
            }
        };
        this._powerControl.addChangeListener(this._powerControlListener);
        this._labelWrapper = new PSwing(this._powerControl.getLabel());
        this._sliderWrapper = new PSwing(this._powerControl.getSlider());
        this._textFieldWrapper = new PSwing(this._powerControl.getTextField());
        this._unitsWrapper = new PSwing(this._powerControl.getUnitsLabel());
        double d3 = 10.0;
        double d4 = 10.0 + this._stopButton.getFullBounds().getWidth() + 20.0 + this._labelWrapper.getFullBounds().getWidth() + 3.0 + this._sliderWrapper.getFullBounds().getWidth() + 3.0 + this._textFieldWrapper.getFullBounds().getWidth() + 3.0 + this._unitsWrapper.getFullBounds().getWidth() + 20.0 + this._signNode.getWidth() + 10.0;
        if (d4 < d) {
            d3 = (d - d4) / 2.0;
            d4 = d;
        }
        double d5 = Math.max(this._stopButton.getFullBounds().getHeight(), this._labelWrapper.getFullBounds().getHeight());
        d5 = Math.max(d5, this._labelWrapper.getFullBounds().getHeight());
        d5 = Math.max(d5, this._sliderWrapper.getFullBounds().getHeight());
        d5 = Math.max(d5, this._textFieldWrapper.getFullBounds().getHeight());
        d5 = Math.max(d5, this._unitsWrapper.getFullBounds().getHeight());
        d5 = Math.max(d5, this._signNode.getFullBounds().getHeight());
        double d6 = 10.0 + d5 + 10.0;
        this._backgroundNode = new PPath(new Rectangle2D.Double(0.0, 0.0, d4, d6));
        this._backgroundNode.setStroke(PANEL_STROKE);
        this._backgroundNode.setStrokePaint(PANEL_STROKE_COLOR);
        this._backgroundNode.setPaint(PANEL_FILL_COLOR);
        this.addChild(this._backgroundNode);
        this.addChild(this._startButton);
        this.addChild(this._stopButton);
        this.addChild(this._labelWrapper);
        this.addChild(this._sliderWrapper);
        this.addChild(this._textFieldWrapper);
        this.addChild(this._unitsWrapper);
        this.addChild(this._signNode);
        this._startButton.addInputEventListener(new CursorHandler());
        this._stopButton.addInputEventListener(new CursorHandler());
        double d7 = this._backgroundNode.getFullBounds().getHeight();
        double d8 = 0.0;
        double d9 = 0.0;
        this._backgroundNode.setOffset(d8, d9);
        d9 = (d7 - this._startButton.getHeight()) / 2.0;
        this._startButton.setOffset(d8 += d3, d9);
        this._stopButton.setOffset(d8, d9);
        d9 = (d7 - this._labelWrapper.getFullBounds().getHeight()) / 2.0;
        this._labelWrapper.setOffset(d8 += this._startButton.getFullBounds().getWidth() + 20.0, d9);
        d9 = (d7 - this._sliderWrapper.getFullBounds().getHeight()) / 2.0;
        this._sliderWrapper.setOffset(d8 += this._labelWrapper.getFullBounds().getWidth() + 3.0, d9);
        d9 = (d7 - this._textFieldWrapper.getFullBounds().getHeight()) / 2.0;
        this._textFieldWrapper.setOffset(d8 += this._sliderWrapper.getFullBounds().getWidth() + 3.0, d9);
        d9 = (d7 - this._unitsWrapper.getFullBounds().getHeight()) / 2.0;
        this._unitsWrapper.setOffset(d8 += this._textFieldWrapper.getFullBounds().getWidth() + 3.0, d9);
        d9 = (d7 - this._signNode.getFullBounds().getHeight()) / 2.0;
        this._signNode.setOffset(d8 += this._unitsWrapper.getFullBounds().getWidth() + 20.0, d9);
        this.updateStartStopButton();
    }

    public void initDragHandler(PNode pNode, PNode pNode2) {
        this.addInputEventListener(new DragHandler(pNode, pNode2));
    }

    public void initDragCursor(Cursor cursor) {
        this._backgroundNode.addInputEventListener(new CursorHandler(cursor));
        this._labelWrapper.addInputEventListener(new CursorHandler(cursor));
        this._unitsWrapper.addInputEventListener(new CursorHandler(cursor));
        this._signNode.addInputEventListener(new CursorHandler(cursor));
        this._sliderWrapper.addInputEventListener(new CursorHandler());
        this._textFieldWrapper.addInputEventListener(new CursorHandler());
    }

    private void updateStartStopButton() {
        boolean bl = this._laser.isRunning();
        this._startButton.setVisible(!bl);
        this._startButton.setPickable(this._startButton.getVisible());
        this._stopButton.setVisible(bl);
        this._stopButton.setPickable(this._stopButton.getVisible());
    }

    public void update(Observable observable, Object object) {
        if (observable == this._laser) {
            if (object == "running") {
                this.updateStartStopButton();
            } else if (object == "power") {
                double d = this._laser.getPower();
                this._powerControl.removeChangeListener(this._powerControlListener);
                this._powerControl.setPower((int)d);
                this._powerControl.addChangeListener(this._powerControlListener);
            }
        }
    }

    private class DragHandler
    extends BoundedDragHandler {
        public DragHandler(PNode pNode, PNode pNode2) {
            super(pNode, pNode2);
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            PNode pNode = pInputEvent.getPickedNode();
            if (pNode != LaserControlPanel.this._startButton && pNode != LaserControlPanel.this._stopButton && pNode != LaserControlPanel.this._sliderWrapper && pNode != LaserControlPanel.this._textFieldWrapper) {
                super.mouseDragged(pInputEvent);
            }
        }
    }
}

