/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.event.DragNotificationHandler;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.LaserPositionController;
import edu.colorado.phet.opticaltweezers.view.BeadNode;
import edu.colorado.phet.opticaltweezers.view.DNAForceNode;
import edu.colorado.phet.opticaltweezers.view.FluidDragForceNode;
import edu.colorado.phet.opticaltweezers.view.LaserNode;
import edu.colorado.phet.opticaltweezers.view.TrapForceNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ForcesControlPanel
extends JPanel
implements Observer {
    private Bead _bead;
    private Fluid _fluid;
    private Laser _laser;
    private LaserPositionController _laserPositionController;
    private TrapForceNode _trapForceNode;
    private FluidDragForceNode _dragForceNode;
    private DNAForceNode _dnaForceNode;
    private JCheckBox _trapForceCheckBox;
    private JCheckBox _dragForceCheckBox;
    private JCheckBox _brownianMotionCheckBox;
    private JCheckBox _dnaForceCheckBox;
    private JCheckBox _showValuesCheckBox;
    private JCheckBox _keepTrapForceConstantCheckBox;

    public ForcesControlPanel(Font font, Font font2, Bead bead, Fluid fluid, Laser laser, LaserPositionController laserPositionController, TrapForceNode trapForceNode, FluidDragForceNode fluidDragForceNode, DNAForceNode dNAForceNode, BeadNode beadNode, LaserNode laserNode) {
        JComponent jComponent;
        this._bead = bead;
        this._bead.addObserver(this);
        this._fluid = fluid;
        this._fluid.addObserver(this);
        this._laser = laser;
        this._laser.addObserver(this);
        if (laserPositionController != null) {
            this._laserPositionController = laserPositionController;
            laserPositionController.addObserver(this);
        }
        this._trapForceNode = trapForceNode;
        this._dragForceNode = fluidDragForceNode;
        this._dnaForceNode = dNAForceNode;
        JLabel jLabel = new JLabel(OTResources.getString("label.forcesOnBead"));
        jLabel.setFont(font);
        JPanel jPanel = null;
        this._trapForceCheckBox = new JCheckBox(OTResources.getString("label.showTrapForce"));
        this._trapForceCheckBox.setFont(font2);
        this._trapForceCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForcesControlPanel.this.handleTrapForceCheckBox();
            }
        });
        JComponent jComponent2 = new JLabel(TrapForceNode.createIcon());
        jComponent2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ForcesControlPanel.this.setTrapForceSelected(!ForcesControlPanel.this.isTrapForceSelected());
            }
        });
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this._trapForceCheckBox);
        jPanel.add(jComponent2);
        jComponent2 = null;
        this._dragForceCheckBox = new JCheckBox(OTResources.getString("label.showDragForce"));
        this._dragForceCheckBox.setFont(font2);
        this._dragForceCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForcesControlPanel.this.handleFluidDragCheckBox();
            }
        });
        JComponent jComponent3 = new JLabel(FluidDragForceNode.createIcon());
        jComponent3.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ForcesControlPanel.this.setDragForceSelected(!ForcesControlPanel.this.isDragForceSelected());
            }
        });
        jComponent2 = new JPanel(new FlowLayout(0, 0, 0));
        jComponent2.add(this._dragForceCheckBox);
        jComponent2.add(jComponent3);
        jComponent3 = null;
        if (this._dnaForceNode != null) {
            this._dnaForceCheckBox = new JCheckBox(OTResources.getString("label.showDNAForce"));
            this._dnaForceCheckBox.setFont(font2);
            this._dnaForceCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ForcesControlPanel.this.handleDNAForceCheckBox();
                }
            });
            jComponent = new JLabel(DNAForceNode.createIcon());
            jComponent.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    ForcesControlPanel.this.setDNAForceSelected(!ForcesControlPanel.this.isDNAForceSelected());
                }
            });
            jComponent3 = new JPanel(new FlowLayout(0, 0, 0));
            jComponent3.add(this._dnaForceCheckBox);
            jComponent3.add(jComponent);
        }
        this._brownianMotionCheckBox = new JCheckBox(OTResources.getString("label.enableBrownianMotion"));
        this._brownianMotionCheckBox.setFont(font2);
        this._brownianMotionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForcesControlPanel.this.handleBrownianMotionCheckBox();
            }
        });
        this._showValuesCheckBox = new JCheckBox(OTResources.getString("label.showForceValues"));
        this._showValuesCheckBox.setFont(font2);
        this._showValuesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForcesControlPanel.this.handleShowValuesCheckBox();
            }
        });
        this._keepTrapForceConstantCheckBox = new JCheckBox(OTResources.getString("label.keepTrapForceConstant"));
        this._keepTrapForceConstantCheckBox.setFont(font2);
        this._keepTrapForceConstantCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForcesControlPanel.this.handleKeepTrapForceConstantCheckBox();
            }
        });
        jComponent = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)jComponent);
        jComponent.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        easyGridBagLayout.setMinimumWidth(0, 20);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jLabel, n++, n2);
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        if (jComponent3 != null) {
            easyGridBagLayout.addComponent(jComponent3, n++, n2);
        }
        easyGridBagLayout.addComponent(jComponent2, n++, n2);
        easyGridBagLayout.addComponent(this._brownianMotionCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._showValuesCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._keepTrapForceConstantCheckBox, n++, n2);
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "West");
        this._trapForceCheckBox.setSelected(false);
        this._dragForceCheckBox.setSelected(false);
        this._dragForceCheckBox.setEnabled(this._fluid.isEnabled());
        this._brownianMotionCheckBox.setSelected(this._bead.isBrownianMotionEnabled());
        this._brownianMotionCheckBox.setEnabled(this._fluid.isEnabled());
        if (this._dnaForceCheckBox != null) {
            this._dnaForceCheckBox.setSelected(false);
        }
        this._showValuesCheckBox.setSelected(false);
        this._keepTrapForceConstantCheckBox.setSelected(false);
        DragNotificationHandler.DragNotificationAdapter dragNotificationAdapter = new DragNotificationHandler.DragNotificationAdapter(){

            public void dragBegin(DragNotificationHandler.DragNotificationEvent dragNotificationEvent) {
                if (ForcesControlPanel.this.isKeepTrapForceConstantSelected()) {
                    ForcesControlPanel.this.setKeepTrapForceConstantSelected(false);
                }
            }
        };
        beadNode.addDragNotificationListener(dragNotificationAdapter);
        laserNode.addDragNotificationListener(dragNotificationAdapter);
    }

    public void setTrapForceSelected(boolean bl) {
        this._trapForceCheckBox.setSelected(bl);
        this.handleTrapForceCheckBox();
    }

    public boolean isTrapForceSelected() {
        return this._trapForceCheckBox.isSelected();
    }

    public void setDragForceSelected(boolean bl) {
        this._dragForceCheckBox.setSelected(bl);
        this.handleFluidDragCheckBox();
    }

    public boolean isDragForceSelected() {
        return this._dragForceCheckBox.isSelected();
    }

    public void setBrownianMotionSelected(boolean bl) {
        this._brownianMotionCheckBox.setSelected(bl);
        this.handleBrownianMotionCheckBox();
    }

    public boolean isBrownianMotionSelected() {
        return this._brownianMotionCheckBox.isSelected();
    }

    public void setDNAForceSelected(boolean bl) {
        if (this._dnaForceCheckBox != null) {
            this._dnaForceCheckBox.setSelected(bl);
            this.handleDNAForceCheckBox();
        }
    }

    public boolean isDNAForceSelected() {
        boolean bl = false;
        if (this._dnaForceCheckBox != null) {
            bl = this._dnaForceCheckBox.isSelected();
        }
        return bl;
    }

    public void setShowValuesSelected(boolean bl) {
        this._showValuesCheckBox.setSelected(bl);
        this.handleShowValuesCheckBox();
    }

    public boolean isShowValuesSelected() {
        return this._showValuesCheckBox.isSelected();
    }

    public void setKeepTrapForceConstantSelected(boolean bl) {
        this._keepTrapForceConstantCheckBox.setSelected(bl);
        this.handleKeepTrapForceConstantCheckBox();
    }

    public boolean isKeepTrapForceConstantSelected() {
        return this._keepTrapForceConstantCheckBox.isSelected();
    }

    public void setShowValuesCheckBoxVisible(boolean bl) {
        this._showValuesCheckBox.setVisible(bl);
    }

    public void setKeepTrapForceConstantCheckBoxVisible(boolean bl) {
        this._keepTrapForceConstantCheckBox.setVisible(bl);
    }

    private void handleTrapForceCheckBox() {
        boolean bl = this._trapForceCheckBox.isSelected();
        this._trapForceNode.setVisible(bl);
    }

    private void handleFluidDragCheckBox() {
        boolean bl = this._dragForceCheckBox.isSelected();
        this._dragForceNode.setVisible(bl);
    }

    private void handleBrownianMotionCheckBox() {
        boolean bl = this._brownianMotionCheckBox.isSelected();
        this._bead.deleteObserver(this);
        this._bead.setBrownianMotionEnabled(bl);
        this._bead.addObserver(this);
    }

    private void handleDNAForceCheckBox() {
        boolean bl = this._dnaForceCheckBox.isSelected();
        this._dnaForceNode.setVisible(bl);
    }

    private void handleShowValuesCheckBox() {
        boolean bl = this._showValuesCheckBox.isSelected();
        this._trapForceNode.setValuesVisible(bl);
        this._dragForceNode.setValuesVisible(bl);
        if (this._dnaForceNode != null) {
            this._dnaForceNode.setValuesVisible(bl);
        }
    }

    private void handleKeepTrapForceConstantCheckBox() {
        if (this._laserPositionController != null) {
            boolean bl = this._keepTrapForceConstantCheckBox.isSelected();
            if (!bl) {
                this._laserPositionController.deleteObserver(this);
                this._laserPositionController.setEnabled(false);
                this._laserPositionController.addObserver(this);
            } else {
                Point2D point2D = this._bead.getPositionReference();
                double d = point2D.getX() - this._bead.getDiameter() / 2.0;
                double d2 = point2D.getX() + this._bead.getDiameter() / 2.0;
                if (this._laser.contains(d, point2D.getY()) || this._laser.contains(d2, point2D.getY())) {
                    this._laserPositionController.deleteObserver(this);
                    this._laserPositionController.setEnabled(true);
                    this._laserPositionController.addObserver(this);
                } else {
                    this._keepTrapForceConstantCheckBox.setSelected(false);
                    PhetFrame phetFrame = PiccoloPhetApplication.getInstance().getPhetFrame();
                    String string = OTResources.getString("message.keepTrapForceConstantInfoDialog");
                    String string2 = OTResources.getString("title.keepTrapForceConstantInfoDialog");
                    PhetOptionPane.showMessageDialog(phetFrame, string, string2, 1);
                }
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._fluid) {
            if (object == "enabled") {
                this._brownianMotionCheckBox.setEnabled(this._fluid.isEnabled());
                this._dragForceCheckBox.setEnabled(this._fluid.isEnabled());
                this._dragForceNode.setVisible(this._fluid.isEnabled() && this._dragForceCheckBox.isSelected());
            }
        } else if (observable == this._bead) {
            if (object == "brownianMotionEnabled") {
                this._brownianMotionCheckBox.setSelected(this._bead.isBrownianMotionEnabled());
            }
        } else if (observable == this._laser) {
            if ((object == "power" || object == "running") && this.isKeepTrapForceConstantSelected()) {
                this.setKeepTrapForceConstantSelected(false);
            }
        } else if (observable == this._laserPositionController && object == "enabled") {
            this._keepTrapForceConstantCheckBox.setSelected(this._laserPositionController.isEnabled());
        }
    }
}

