/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.DefaultLayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LogarithmicValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import java.awt.Font;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FluidControlPanel
extends VerticalLayoutPanel
implements Observer {
    private static final Insets INSETS = new Insets(1, 2, 0, 2);
    private Fluid _fluid;
    private LinearValueControl _speedControl;
    private LogarithmicValueControl _viscosityControl;
    private LinearValueControl _temperatureControl;
    private LinearValueControl _atpControl;

    public FluidControlPanel(Fluid fluid, Font font) {
        this.setInsets(INSETS);
        this._fluid = fluid;
        this._fluid.addObserver(this);
        double d = fluid.getSpeed() / 1000.0;
        double d2 = fluid.getSpeedRange().getMin() / 1000.0;
        double d3 = fluid.getSpeedRange().getMax() / 1000.0;
        String string = OTResources.getString("label.fluidSpeed");
        String string2 = "###0";
        String string3 = OTResources.getString("units.fluidSpeed");
        this._speedControl = new LinearValueControl(d2, d3, string, string2, string3, new FluidControlLayoutStrategy());
        this._speedControl.setValue(d);
        this._speedControl.setUpDownArrowDelta(1.0);
        this._speedControl.setTextFieldEditable(true);
        this._speedControl.setFont(font);
        this._speedControl.setTickPattern("0");
        this._speedControl.setMajorTickSpacing((d3 - d2) / 2.0);
        this._speedControl.setMinorTickSpacing(100.0);
        this._speedControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FluidControlPanel.this.handleSpeedChange();
            }
        });
        d = fluid.getViscosity();
        d2 = fluid.getViscosityRange().getMin();
        d3 = fluid.getViscosityRange().getMax();
        string = OTResources.getString("label.fluidViscosity");
        string2 = "0.0E0";
        string3 = OTResources.getString("units.fluidViscosity");
        this._viscosityControl = new LogarithmicValueControl(d2, d3, string, string2, string3, new FluidControlLayoutStrategy());
        this._viscosityControl.setValue(d);
        this._viscosityControl.setTextFieldEditable(true);
        this._viscosityControl.setFont(font);
        this._viscosityControl.setUpDownArrowDelta(10.0);
        this._viscosityControl.setTickPattern("0E0");
        this._viscosityControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FluidControlPanel.this.handleViscosityChange();
            }
        });
        d = fluid.getTemperature();
        d2 = fluid.getTemperatureRange().getMin();
        d3 = fluid.getTemperatureRange().getMax();
        string = OTResources.getString("label.fluidTemperature");
        string2 = "##0";
        string3 = OTResources.getString("units.fluidTemperature");
        this._temperatureControl = new LinearValueControl(d2, d3, string, string2, string3, new FluidControlLayoutStrategy());
        this._temperatureControl.setValue(d);
        this._temperatureControl.setTextFieldEditable(true);
        this._temperatureControl.setFont(font);
        this._temperatureControl.setUpDownArrowDelta(1.0);
        this._temperatureControl.setTickPattern("0");
        this._temperatureControl.setMajorTickSpacing((d3 - d2) / 2.0);
        this._temperatureControl.setMinorTickSpacing(50.0);
        this._temperatureControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FluidControlPanel.this.handleTemperatureChange();
            }
        });
        if (fluid.getATPConcentrationRange().getLength() != 0.0) {
            d = fluid.getATPConcentration();
            d2 = fluid.getATPConcentrationRange().getMin();
            d3 = fluid.getATPConcentrationRange().getMax();
            string = OTResources.getString("label.atpConcentration");
            string2 = "#0.0";
            string3 = "";
            this._atpControl = new LinearValueControl(d2, d3, string, string2, string3, new FluidControlLayoutStrategy());
            this._atpControl.setValue(d);
            this._atpControl.setTextFieldEditable(true);
            this._atpControl.setFont(font);
            this._atpControl.setUpDownArrowDelta(0.1);
            this._atpControl.setTickPattern("0");
            this._atpControl.setMajorTickSpacing((d3 - d2) / 2.0);
            this._atpControl.setMinorTickSpacing(1.0);
            this._atpControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    FluidControlPanel.this.handleATPChange();
                }
            });
        }
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(INSETS);
        int n = 0;
        int n2 = 0;
        if (this._atpControl != null) {
            easyGridBagLayout.addComponent(this._atpControl, n++, n2);
            easyGridBagLayout.addComponent(new JSeparator(), n++, n2);
        }
        easyGridBagLayout.addComponent(this._speedControl, n++, n2);
        easyGridBagLayout.addComponent(new JSeparator(), n++, n2);
        easyGridBagLayout.addComponent(this._viscosityControl, n++, n2);
        easyGridBagLayout.addComponent(new JSeparator(), n++, n2);
        easyGridBagLayout.addComponent(this._temperatureControl, n++, n2);
        int n3 = (int)this._speedControl.getPreferredSize().getWidth();
        int n4 = (int)this._viscosityControl.getPreferredSize().getWidth();
        int n5 = (int)this._temperatureControl.getPreferredSize().getWidth();
        int n6 = this._atpControl == null ? 0 : (int)this._atpControl.getPreferredSize().getWidth();
        int n7 = Math.max(Math.max(n3, Math.max(n4, n5)), n6);
        this._speedControl.setSliderWidth(n7);
        this._viscosityControl.setSliderWidth(n7);
        this._temperatureControl.setSliderWidth(n7);
        if (this._atpControl != null) {
            this._atpControl.setSliderWidth(n7);
        }
    }

    public void cleanup() {
        this._fluid.deleteObserver(this);
    }

    private void handleSpeedChange() {
        double d = this._speedControl.getValue() * 1000.0;
        this._fluid.deleteObserver(this);
        this._fluid.setSpeed(d);
        this._fluid.addObserver(this);
    }

    private void handleViscosityChange() {
        double d = this._viscosityControl.getValue();
        this._fluid.deleteObserver(this);
        this._fluid.setViscosity(d);
        this._fluid.addObserver(this);
    }

    private void handleTemperatureChange() {
        double d = this._temperatureControl.getValue();
        this._fluid.deleteObserver(this);
        this._fluid.setTemperature(d);
        this._fluid.addObserver(this);
    }

    private void handleATPChange() {
        double d = this._atpControl.getValue();
        this._fluid.deleteObserver(this);
        this._fluid.setATPConcentration(d);
        this._fluid.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._fluid) {
            this._speedControl.setValue(this._fluid.getSpeed() / 1000.0);
            this._viscosityControl.setValue(this._fluid.getViscosity());
            this._temperatureControl.setValue(this._fluid.getTemperature());
            if (this._atpControl != null) {
                this._atpControl.setValue(this._fluid.getATPConcentration());
            }
        }
    }

    private static class FluidControlLayoutStrategy
    extends DefaultLayoutStrategy {
        public FluidControlLayoutStrategy() {
            super(2, INSETS);
        }
    }
}

