/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ChargeControlPanel
extends JPanel {
    private PNode _chargeDistributionNode;
    private PNode _chargeExcessNode;
    private JRadioButton _hiddenRadioButton;
    private JRadioButton _distributionRadioButton;
    private JRadioButton _excessRadioButton;

    public ChargeControlPanel(Font font, Font font2, PNode pNode, PNode pNode2) {
        this._chargeDistributionNode = pNode;
        this._chargeExcessNode = pNode2;
        JLabel jLabel = new JLabel(OTResources.getString("title.chargeControlPanel"));
        jLabel.setFont(font);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChargeControlPanel.this.handleChargeChoice();
            }
        };
        this._hiddenRadioButton = new JRadioButton(OTResources.getString("choice.noCharge"));
        this._hiddenRadioButton.setFont(font2);
        this._hiddenRadioButton.addActionListener(actionListener);
        this._distributionRadioButton = new JRadioButton(OTResources.getString("choice.chargeDistribution"));
        this._distributionRadioButton.setFont(font2);
        this._distributionRadioButton.addActionListener(actionListener);
        this._excessRadioButton = new JRadioButton(OTResources.getString("choice.chargeExcess"));
        this._excessRadioButton.setFont(font2);
        this._excessRadioButton.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._hiddenRadioButton);
        buttonGroup.add(this._distributionRadioButton);
        buttonGroup.add(this._excessRadioButton);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setFill(2);
        easyGridBagLayout.setInsets(OTConstants.SUB_PANEL_INSETS);
        easyGridBagLayout.setMinimumWidth(0, 20);
        int n = 0;
        easyGridBagLayout.addComponent(jLabel, n++, 0);
        easyGridBagLayout.addComponent(this._hiddenRadioButton, n++, 0);
        easyGridBagLayout.addComponent(this._distributionRadioButton, n++, 0);
        easyGridBagLayout.addComponent(this._excessRadioButton, n++, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this._hiddenRadioButton.setSelected(true);
    }

    public void setHiddenSelected(boolean bl) {
        this._hiddenRadioButton.setSelected(bl);
        this.handleChargeChoice();
    }

    public void setDistributionSelected(boolean bl) {
        this._distributionRadioButton.setSelected(bl);
        this.handleChargeChoice();
    }

    public boolean isDistributionSelected() {
        return this._distributionRadioButton.isSelected();
    }

    public void setExcessSelected(boolean bl) {
        this._excessRadioButton.setSelected(bl);
        this.handleChargeChoice();
    }

    public boolean isExcessSelected() {
        return this._excessRadioButton.isSelected();
    }

    private void handleChargeChoice() {
        this._chargeDistributionNode.setVisible(this.isDistributionSelected());
        this._chargeExcessNode.setVisible(this.isExcessSelected());
    }
}

