/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.charts;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.opticaltweezers.OTResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PotentialEnergyPlot
extends XYPlot {
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0, 0);
    private static final Color PLOT_COLOR = new Color(178, 25, 205);
    private static final Stroke PLOT_STROKE = new BasicStroke(2.0f);
    private static final Font AXIS_LABEL_FONT = new PhetFont(0, 14);
    private XYSeries _series;
    private NumberAxis _xAxis;
    private NumberAxis _yAxis;

    public PotentialEnergyPlot() {
        String string = OTResources.getString("axis.position");
        String string2 = OTResources.getString("axis.potentialEnergy");
        this._series = new XYSeries((Comparable)((Object)"potentialEnergy"), false);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(this._series);
        this.setDataset(xYSeriesCollection);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setDrawSeriesLineAsPath(true);
        standardXYItemRenderer.setPaint(PLOT_COLOR);
        standardXYItemRenderer.setStroke(PLOT_STROKE);
        this.setRenderer(standardXYItemRenderer);
        this._xAxis = new NumberAxis();
        this._xAxis.setLabel(string);
        this._xAxis.setLabelFont(AXIS_LABEL_FONT);
        this._xAxis.setTickLabelsVisible(false);
        this._xAxis.setTickMarksVisible(false);
        this.setDomainAxis(this._xAxis);
        this._yAxis = new NumberAxis();
        this._yAxis.setLabel(string2);
        this._yAxis.setLabelFont(AXIS_LABEL_FONT);
        this._yAxis.setTickLabelsVisible(false);
        this._yAxis.setTickMarksVisible(false);
        this.setRangeAxis(this._yAxis);
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setBackgroundPaint(BACKGROUND_COLOR);
        this.setDomainGridlinesVisible(false);
        this.setRangeGridlinesVisible(false);
        this.setPositionRange(0.0, 1.0);
        this.setPotentialEnergyRange(0.0, 1.0);
    }

    public void setPositionRange(double d, double d2) {
        this._xAxis.setRange(d, d2);
    }

    public Range getPositionRange() {
        return this._xAxis.getRange();
    }

    public void setPotentialEnergyRange(double d, double d2) {
        this._yAxis.setRange(d, d2);
    }

    public Range getPotentialEnergyRange() {
        return this._yAxis.getRange();
    }

    public void addData(double d, double d2) {
        this._series.add(d, d2);
    }

    public void clear() {
        this._series.clear();
    }
}

