/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.charts;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.charts.PositionHistogramPlot;
import edu.colorado.phet.opticaltweezers.dialog.PositionHistogramSnapshotDialog;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.ValueMarker;

public class PositionHistogramPanel
extends JPanel
implements Observer {
    private static final Dimension CHART_SIZE = new Dimension(700, 150);
    private static final Color CHART_BACKGROUND_COLOR = Color.WHITE;
    private static final Color SNAPSHOT_BACKGROUND_COLOR = new Color(225, 225, 225);
    private static final ZoomLevel[] ZOOM_LEVELS = new ZoomLevel[]{new ZoomLevel(52.0, 1.0, 75, 5, 1.0), new ZoomLevel(105.0, 2.0, 150, 10, 2.0), new ZoomLevel(160.0, 3.0, 225, 25, 5.0), new ZoomLevel(210.0, 5.0, 300, 25, 5.0), new ZoomLevel(260.0, 5.0, 375, 25, 5.0), new ZoomLevel(320.0, 7.5, 450, 50, 5.0)};
    private static final DecimalFormat BIN_WIDTH_FORMAT = new DecimalFormat("0.0#");
    private IClock _clock;
    private ClockListener _clockListener;
    private Bead _bead;
    private Laser _laser;
    private JButton _startStopButton;
    private JButton _clearButton;
    private JButton _zoomInButton;
    private JButton _zoomOutButton;
    private JButton _snapshotButton;
    private JButton _rulerButton;
    private PositionHistogramPlot _plot;
    private PText _measurementsNode;
    private PText _binWidthNode;
    private PClip _snapshotClipNode;
    private JFreeChart _chart;
    private JFreeChartNode _chartNode;
    private String _measurementsString;
    private String _startString;
    private String _stopString;
    private String _binWidthString;
    private String _unitsString;
    private String _positionHistogramSnapshotTitle;
    private boolean _isRunning;
    private int _numberOfMeasurements;
    private int _zoomIndex;
    private Dialog _snapshotDialogOwner;
    private ArrayList _snapshotDialogs;
    private int _numberOfSnapshots;
    private RulerNode _rulerNode;
    private PNode _rulerParentNode;
    private PNode _rulerDragBoundsNode;

    public PositionHistogramPanel(Dialog dialog, Font font, IClock iClock, Bead bead, Laser laser) {
        this._snapshotDialogOwner = dialog;
        this._clock = iClock;
        this._clockListener = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                if (PositionHistogramPanel.this._isRunning) {
                    PositionHistogramPanel.this.handleClockEvent(clockEvent);
                }
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                PositionHistogramPanel.this.clearMeasurements();
            }
        };
        this._clock.addClockListener(this._clockListener);
        this._bead = bead;
        this._laser = laser;
        this._laser.addObserver(this);
        this._isRunning = true;
        this._numberOfMeasurements = 0;
        this._snapshotDialogs = new ArrayList();
        this._numberOfSnapshots = 0;
        this.initStrings();
        JPanel jPanel = this.createToolPanel(font);
        JPanel jPanel2 = this.createChartPanel(font, bead, laser);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.setZoomIndex(2);
    }

    public void cleanup() {
        this._clock.removeClockListener(this._clockListener);
        this._laser.deleteObserver(this);
        Iterator iterator = this._snapshotDialogs.iterator();
        while (iterator.hasNext()) {
            ((JDialog)iterator.next()).dispose();
        }
        this._snapshotDialogs.clear();
    }

    private void initStrings() {
        this._measurementsString = OTResources.getString("label.measurements");
        this._startString = OTResources.getString("button.start");
        this._stopString = OTResources.getString("button.stop");
        this._binWidthString = OTResources.getString("label.binWidth");
        this._unitsString = OTResources.getString("units.position");
        this._positionHistogramSnapshotTitle = OTResources.getString("title.positionHistogramSnapshot");
    }

    private JPanel createToolPanel(Font font) {
        this._startStopButton = new JButton(this._isRunning ? this._stopString : this._startString);
        this._startStopButton.setFont(font);
        this._startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.handleStartStopButton();
            }
        });
        this._clearButton = new JButton(OTResources.getString("button.clear"));
        this._clearButton.setFont(font);
        this._clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.clearMeasurements();
            }
        });
        ImageIcon imageIcon = new ImageIcon(OTResources.getImage("zoomIn.png"));
        this._zoomInButton = new JButton(imageIcon);
        this._zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.handleZoomInButton();
            }
        });
        this._zoomInButton.setEnabled(this._zoomIndex != 0);
        ImageIcon imageIcon2 = new ImageIcon(OTResources.getImage("zoomOut.png"));
        this._zoomOutButton = new JButton(imageIcon2);
        this._zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.handleZoomOutButton();
            }
        });
        this._zoomOutButton.setEnabled(this._zoomIndex != ZOOM_LEVELS.length - 1);
        ImageIcon imageIcon3 = new ImageIcon(OTResources.getImage("cameraIcon.png"));
        this._snapshotButton = new JButton(imageIcon3);
        this._snapshotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.handleSnapshotButton();
            }
        });
        ImageIcon imageIcon4 = new ImageIcon(OTResources.getImage("rulerIcon.png"));
        this._rulerButton = new JButton(imageIcon4);
        this._rulerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionHistogramPanel.this.handleRulerButton();
            }
        });
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.setFill(2);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._startStopButton, n, n2++, 1, 1, 13);
        easyGridBagLayout.addComponent(this._clearButton, n, n2++, 1, 1, 13);
        easyGridBagLayout.addComponent(this._zoomInButton, n, n2++, 1, 1, 13);
        easyGridBagLayout.addComponent(this._zoomOutButton, n, n2++, 1, 1, 13);
        easyGridBagLayout.addComponent(this._snapshotButton, n, n2++, 1, 1, 13);
        easyGridBagLayout.addComponent(this._rulerButton, n, n2++, 1, 1, 13);
        return jPanel;
    }

    private JPanel createChartPanel(Font font, Bead bead, Laser laser) {
        PhetPCanvas phetPCanvas = new PhetPCanvas();
        phetPCanvas.setPreferredSize(CHART_SIZE);
        this._snapshotClipNode = new PClip();
        this._snapshotClipNode.setPathTo(new Rectangle2D.Double(0.0, 0.0, PositionHistogramPanel.CHART_SIZE.width, PositionHistogramPanel.CHART_SIZE.height));
        this._snapshotClipNode.setPaint(null);
        this._snapshotClipNode.setStroke(null);
        this._snapshotClipNode.setOffset(0.0, 0.0);
        this._plot = new PositionHistogramPlot();
        this._plot.setBackgroundPaint(CHART_BACKGROUND_COLOR);
        ValueMarker valueMarker = new ValueMarker(0.0);
        valueMarker.setLabel("");
        valueMarker.setPaint(OTConstants.ORIGIN_MARKER_COLOR);
        valueMarker.setStroke(OTConstants.ORIGIN_MARKER_STROKE);
        this._plot.addDomainMarker(valueMarker);
        this._chart = new JFreeChart(null, null, this._plot, false);
        this._chart.setAntiAlias(true);
        this._chart.setBorderVisible(true);
        this._chart.setBackgroundPaint(CHART_BACKGROUND_COLOR);
        this._chartNode = new JFreeChartNode(this._chart);
        this._chartNode.setPickable(false);
        this._chartNode.setChildrenPickable(false);
        this._chartNode.setOffset(0.0, 0.0);
        this._chartNode.setBounds(0.0, 0.0, PositionHistogramPanel.CHART_SIZE.width, PositionHistogramPanel.CHART_SIZE.height);
        this._chartNode.updateChartRenderingInfo();
        this._measurementsNode = new PText("?");
        this._measurementsNode.setOffset(10.0, 10.0);
        this._measurementsNode.setPickable(false);
        this.setNumberOfMeasurements(this._numberOfMeasurements);
        this._binWidthNode = new PText();
        this._binWidthNode.setOffset(this._measurementsNode.getXOffset(), this._measurementsNode.getFullBounds().getMaxY() + 3.0);
        this._binWidthNode.setPickable(false);
        this._rulerParentNode = new PNode();
        this._rulerParentNode.setOffset(0.0, 0.0);
        this._snapshotClipNode.addChild(this._chartNode);
        this._snapshotClipNode.addChild(this._measurementsNode);
        this._snapshotClipNode.addChild(this._binWidthNode);
        this._snapshotClipNode.addChild(this._rulerParentNode);
        phetPCanvas.getLayer().addChild(this._snapshotClipNode);
        JPanel jPanel = new JPanel();
        jPanel.add(phetPCanvas);
        return jPanel;
    }

    public Image getSnapshotImage() {
        return this._snapshotClipNode.toImage();
    }

    public void setZoomIndex(int n) {
        if (n < 0 || n > ZOOM_LEVELS.length - 1) {
            throw new IndexOutOfBoundsException("zoomIndex out of bounds: " + n);
        }
        this._zoomIndex = n;
        ZoomLevel zoomLevel = ZOOM_LEVELS[this._zoomIndex];
        this._plot.setPositionRange(-zoomLevel.positionRange, zoomLevel.positionRange, zoomLevel.binWidth);
        this._binWidthNode.setText(this._binWidthString + " " + BIN_WIDTH_FORMAT.format(zoomLevel.binWidth) + " " + this._unitsString);
        this._zoomInButton.setEnabled(this._zoomIndex != 0);
        this._zoomOutButton.setEnabled(this._zoomIndex != ZOOM_LEVELS.length - 1);
        this.updateRuler();
    }

    public int getZoomIndex() {
        return this._zoomIndex;
    }

    public void setRulerVisible(boolean bl) {
        this.updateRuler();
        this._rulerNode.setVisible(bl);
    }

    public boolean isRulerVisible() {
        return this._rulerNode != null && this._rulerNode.isVisible();
    }

    private void setNumberOfMeasurements(int n) {
        this._numberOfMeasurements = n;
        this._measurementsNode.setText(this._measurementsString + " " + String.valueOf(this._numberOfMeasurements));
    }

    private void setRunning(boolean bl) {
        this._isRunning = bl;
        if (this._isRunning) {
            this._clock.addClockListener(this._clockListener);
            this._startStopButton.setText(this._stopString);
        } else {
            this._clock.removeClockListener(this._clockListener);
            this._startStopButton.setText(this._startString);
        }
    }

    private void clearMeasurements() {
        if (this._numberOfMeasurements > 0) {
            this._plot.clear();
            this.setNumberOfMeasurements(0);
        }
    }

    private void handleStartStopButton() {
        this.setRunning(!this._isRunning);
    }

    private void handleZoomInButton() {
        int n = this._zoomIndex - 1;
        this.setZoomIndex(n);
    }

    private void handleZoomOutButton() {
        int n = this._zoomIndex + 1;
        this.setZoomIndex(n);
    }

    private void handleSnapshotButton() {
        this._plot.setBackgroundPaint(SNAPSHOT_BACKGROUND_COLOR);
        this._chart.setBackgroundPaint(SNAPSHOT_BACKGROUND_COLOR);
        String string = this._positionHistogramSnapshotTitle + " " + ++this._numberOfSnapshots;
        PositionHistogramSnapshotDialog positionHistogramSnapshotDialog = new PositionHistogramSnapshotDialog(this._snapshotDialogOwner, string, this);
        this._snapshotDialogs.add(positionHistogramSnapshotDialog);
        int n = this._numberOfSnapshots * 10 % 200;
        int n2 = (int)this._snapshotDialogOwner.getLocation().getX() + n;
        int n3 = (int)this._snapshotDialogOwner.getLocation().getY() + this._snapshotDialogOwner.getHeight() + n;
        positionHistogramSnapshotDialog.setLocation(n2, n3);
        positionHistogramSnapshotDialog.show();
        this._plot.setBackgroundPaint(CHART_BACKGROUND_COLOR);
        this._chart.setBackgroundPaint(CHART_BACKGROUND_COLOR);
    }

    private void handleRulerButton() {
        this._rulerNode.setVisible(!this._rulerNode.isVisible());
    }

    private void updateRuler() {
        int n;
        boolean bl = false;
        if (this._rulerNode != null) {
            bl = this._rulerNode.isVisible();
            this._rulerParentNode.removeAllChildren();
            this._rulerNode = null;
            this._rulerDragBoundsNode = null;
        }
        ZoomLevel zoomLevel = ZOOM_LEVELS[this._zoomIndex];
        double d = this.getRulerNodeLength(zoomLevel.rulerMax);
        int n2 = zoomLevel.rulerMax / zoomLevel.rulerMajorTickSpacing + 1;
        int n3 = zoomLevel.rulerMax / (n2 - 1);
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = String.valueOf(n * n3);
        }
        n = (int)((double)zoomLevel.rulerMajorTickSpacing / zoomLevel.rulerMinorTickSpacing) - 1;
        this._rulerNode = new RulerNode(d, 30.0, stringArray, this._unitsString, n, 10);
        this._rulerParentNode.addChild(this._rulerNode);
        this._rulerNode.addInputEventListener(new CursorHandler());
        this._rulerNode.setBackgroundPaint(OTConstants.RULER_COLOR);
        PBounds pBounds = this._snapshotClipNode.getFullBoundsReference();
        PBounds pBounds2 = this._rulerNode.getFullBoundsReference();
        double d2 = pBounds.getX() - pBounds2.getWidth() + 20.0;
        double d3 = pBounds.getY();
        double d4 = pBounds.getWidth() + 2.0 * pBounds2.getWidth() - 40.0;
        double d5 = pBounds.getHeight();
        this._rulerDragBoundsNode = new PPath(new Rectangle2D.Double(d2, d3, d4, d5));
        this._rulerParentNode.addChild(this._rulerDragBoundsNode);
        this._rulerNode.addInputEventListener(new BoundedDragHandler(this._rulerNode, this._rulerDragBoundsNode));
        PBounds pBounds3 = this._chartNode.getFullBoundsReference();
        double d6 = (pBounds3.getWidth() - pBounds2.getWidth()) / 2.0;
        double d7 = (pBounds3.getHeight() - pBounds2.getHeight()) / 2.0;
        this._rulerNode.setOffset(d6, d7);
        this._rulerNode.setVisible(bl);
    }

    private double getRulerNodeLength(double d) {
        Point2D point2D = this._chartNode.plotToNode(new Point2D.Double(0.0, 0.0));
        Point2D point2D2 = this._chartNode.plotToNode(new Point2D.Double(d, 0.0));
        Point2D point2D3 = this._chartNode.localToGlobal(point2D);
        Point2D point2D4 = this._chartNode.localToGlobal(point2D2);
        Point2D point2D5 = this._rulerParentNode.globalToLocal(point2D3);
        Point2D point2D6 = this._rulerParentNode.globalToLocal(point2D4);
        return point2D6.getX() - point2D5.getX();
    }

    private void handleClockEvent(ClockEvent clockEvent) {
        this.setNumberOfMeasurements(this._numberOfMeasurements + 1);
        double d = this._bead.getPositionReference().getX() - this._laser.getPositionReference().getX();
        this._plot.addPosition(d);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._laser && object == "position") {
            this.clearMeasurements();
        }
    }

    private static class ZoomLevel {
        public final double positionRange;
        public final double binWidth;
        public final int rulerMax;
        public final int rulerMajorTickSpacing;
        public final double rulerMinorTickSpacing;

        public ZoomLevel(double d, double d2, int n, int n2, double d3) {
            if (!(d > 0.0)) {
                throw new IllegalArgumentException("positionRange must be > 0");
            }
            if (!(d2 > 0.0)) {
                throw new IllegalArgumentException("binWidth must be > 0");
            }
            if (n % n2 != 0) {
                throw new IllegalArgumentException("rulerMax must be an integer multiple of rulerMajorTickSpacing");
            }
            if (!((double)n2 > d3)) {
                throw new IllegalArgumentException("rulerMajorTickSpacing must be > rulerMinorTickSpacing");
            }
            if ((double)n2 % d3 != 0.0) {
                throw new IllegalArgumentException("rulerMajorTickSpacing must an integer multiple of rulerMinorTickSpacing");
            }
            this.positionRange = d;
            this.binWidth = d2;
            this.rulerMax = n;
            this.rulerMajorTickSpacing = n2;
            this.rulerMinorTickSpacing = d3;
        }
    }
}

