/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.opticaltweezers.OTAbstractApplication;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModule;
import edu.colorado.phet.opticaltweezers.persistence.DNAConfig;
import edu.colorado.phet.opticaltweezers.persistence.GlobalConfig;
import edu.colorado.phet.opticaltweezers.persistence.StretchingDNAConfig;

public class StretchingDNAApplication
extends OTAbstractApplication {
    private DNAModule _dnaModule;
    private XMLPersistenceManager _persistenceManager;

    public StretchingDNAApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
    }

    protected void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this._dnaModule = new DNAModule(phetFrame);
        this.addModule(this._dnaModule);
    }

    public void save() {
        StretchingDNAConfig stretchingDNAConfig = new StretchingDNAConfig();
        GlobalConfig globalConfig = stretchingDNAConfig.getGlobalConfig();
        globalConfig.setVersionString(this.getSimInfo().getVersion().toString());
        globalConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        globalConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        globalConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        globalConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        DNAConfig dNAConfig = this._dnaModule.save();
        stretchingDNAConfig.setDNAConfig(dNAConfig);
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        this._persistenceManager.save(stretchingDNAConfig);
    }

    public void load() {
        Object object;
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        if ((object = this._persistenceManager.load()) != null) {
            if (object instanceof StretchingDNAConfig) {
                StretchingDNAConfig stretchingDNAConfig = (StretchingDNAConfig)object;
                this._dnaModule.load(stretchingDNAConfig.getDNAConfig());
            } else {
                String string = PhetCommonResources.getString("XMLPersistenceManager.message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new StretchingDNAApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "optical-tweezers", "stretching-dna");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

