/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.opticaltweezers.OTAbstractApplication;
import edu.colorado.phet.opticaltweezers.module.dna.DNAModule;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsModule;
import edu.colorado.phet.opticaltweezers.module.physics.PhysicsModule;
import edu.colorado.phet.opticaltweezers.persistence.DNAConfig;
import edu.colorado.phet.opticaltweezers.persistence.GlobalConfig;
import edu.colorado.phet.opticaltweezers.persistence.MotorsConfig;
import edu.colorado.phet.opticaltweezers.persistence.OpticalTweezersConfig;
import edu.colorado.phet.opticaltweezers.persistence.PhysicsConfig;

public class OpticalTweezersApplication
extends OTAbstractApplication {
    private PhysicsModule _physicsModule;
    private DNAModule _dnaModule;
    private MotorsModule _motorsModule;
    private XMLPersistenceManager _persistenceManager;

    public OpticalTweezersApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
    }

    protected void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this._physicsModule = new PhysicsModule(phetFrame);
        this.addModule(this._physicsModule);
        this._dnaModule = new DNAModule(phetFrame);
        this.addModule(this._dnaModule);
        this._motorsModule = new MotorsModule(phetFrame);
        this.addModule(this._motorsModule);
    }

    public void save() {
        OpticalTweezersConfig opticalTweezersConfig = new OpticalTweezersConfig();
        GlobalConfig globalConfig = opticalTweezersConfig.getGlobalConfig();
        globalConfig.setVersionString(this.getSimInfo().getVersion().toString());
        globalConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        globalConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        globalConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        globalConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        PhysicsConfig physicsConfig = this._physicsModule.save();
        opticalTweezersConfig.setPhysicsConfig(physicsConfig);
        DNAConfig dNAConfig = this._dnaModule.save();
        opticalTweezersConfig.setDNAConfig(dNAConfig);
        MotorsConfig motorsConfig = this._motorsModule.save();
        opticalTweezersConfig.setMotorsConfig(motorsConfig);
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        this._persistenceManager.save(opticalTweezersConfig);
    }

    public void load() {
        Object object;
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        if ((object = this._persistenceManager.load()) != null) {
            if (object instanceof OpticalTweezersConfig) {
                OpticalTweezersConfig opticalTweezersConfig = (OpticalTweezersConfig)object;
                this._physicsModule.load(opticalTweezersConfig.getPhysicsConfig());
                this._dnaModule.load(opticalTweezersConfig.getDNAConfig());
                this._motorsModule.load(opticalTweezersConfig.getMotorsConfig());
            } else {
                String string = PhetCommonResources.getString("XMLPersistenceManager.message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new OpticalTweezersApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "optical-tweezers", "optical-tweezers");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

