/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.persistence.XMLPersistenceManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.opticaltweezers.OTAbstractApplication;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsModule;
import edu.colorado.phet.opticaltweezers.persistence.GlobalConfig;
import edu.colorado.phet.opticaltweezers.persistence.MolecularMotorsConfig;
import edu.colorado.phet.opticaltweezers.persistence.MotorsConfig;

public class MolecularMotorsApplication
extends OTAbstractApplication {
    private MotorsModule _motorsModule;
    private XMLPersistenceManager _persistenceManager;

    public MolecularMotorsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
    }

    protected void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this._motorsModule = new MotorsModule(phetFrame);
        this.addModule(this._motorsModule);
    }

    public void save() {
        MolecularMotorsConfig molecularMotorsConfig = new MolecularMotorsConfig();
        GlobalConfig globalConfig = molecularMotorsConfig.getGlobalConfig();
        globalConfig.setVersionString(this.getSimInfo().getVersion().toString());
        globalConfig.setVersionMajor(this.getSimInfo().getVersion().getMajor());
        globalConfig.setVersionMinor(this.getSimInfo().getVersion().getMinor());
        globalConfig.setVersionDev(this.getSimInfo().getVersion().getDev());
        globalConfig.setVersionRevision(this.getSimInfo().getVersion().getRevision());
        MotorsConfig motorsConfig = this._motorsModule.save();
        molecularMotorsConfig.setMotorsConfig(motorsConfig);
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        this._persistenceManager.save(molecularMotorsConfig);
    }

    public void load() {
        Object object;
        if (this._persistenceManager == null) {
            this._persistenceManager = new XMLPersistenceManager(this.getPhetFrame());
        }
        if ((object = this._persistenceManager.load()) != null) {
            if (object instanceof MolecularMotorsConfig) {
                MolecularMotorsConfig molecularMotorsConfig = (MolecularMotorsConfig)object;
                this._motorsModule.load(molecularMotorsConfig.getMotorsConfig());
            } else {
                String string = PhetCommonResources.getString("XMLPersistenceManager.message.notAConfigFile");
                PhetOptionPane.showErrorDialog(this.getPhetFrame(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new MolecularMotorsApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "optical-tweezers", "molecular-motors");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

