/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;

public class DragNotificationHandler
extends PBasicInputEventHandler {
    private Object eventSource;
    private EventListenerList listenerList = new EventListenerList();

    public DragNotificationHandler() {
        this(null);
    }

    public DragNotificationHandler(Object object) {
        this.eventSource = object;
        if (object == null) {
            this.eventSource = this;
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.fireDragBegin(new DragNotificationEvent(this.eventSource));
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        this.fireDragged(new DragNotificationEvent(this.eventSource));
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        this.fireDragEnd(new DragNotificationEvent(this.eventSource));
    }

    public void addDragNotificationListener(DragNotificationListener dragNotificationListener) {
        this.listenerList.add(DragNotificationListener.class, dragNotificationListener);
    }

    private void fireDragBegin(DragNotificationEvent dragNotificationEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != DragNotificationListener.class) continue;
            ((DragNotificationListener)objectArray[i + 1]).dragBegin(dragNotificationEvent);
        }
    }

    private void fireDragged(DragNotificationEvent dragNotificationEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != DragNotificationListener.class) continue;
            ((DragNotificationListener)objectArray[i + 1]).dragged(dragNotificationEvent);
        }
    }

    private void fireDragEnd(DragNotificationEvent dragNotificationEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != DragNotificationListener.class) continue;
            ((DragNotificationListener)objectArray[i + 1]).dragEnd(dragNotificationEvent);
        }
    }

    public static class DragNotificationAdapter
    implements DragNotificationListener {
        public void dragBegin(DragNotificationEvent dragNotificationEvent) {
        }

        public void dragEnd(DragNotificationEvent dragNotificationEvent) {
        }

        public void dragged(DragNotificationEvent dragNotificationEvent) {
        }
    }

    public static class DragNotificationEvent
    extends EventObject {
        public DragNotificationEvent(Object object) {
            super(object);
        }
    }

    public static interface DragNotificationListener
    extends EventListener {
        public void dragBegin(DragNotificationEvent var1);

        public void dragged(DragNotificationEvent var1);

        public void dragEnd(DragNotificationEvent var1);
    }
}

