/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls.valuecontrol;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractMappingStrategy;

public class LogarithmicMappingStrategy
extends AbstractMappingStrategy {
    private final double _logMin;
    private final double _logMax;
    private final double _logRange;
    private final double _scalingFactor;

    public LogarithmicMappingStrategy(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
        if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
            throw new IllegalArgumentException("modelMin and modelMax must have the same sign");
        }
        this._scalingFactor = Math.abs(d) < 1.0 ? 1.0 / Math.abs(d) : 1.0;
        this._logMin = LogarithmicMappingStrategy.adjustedLog10(d * this._scalingFactor);
        this._logMax = LogarithmicMappingStrategy.adjustedLog10(d2 * this._scalingFactor);
        this._logRange = this._logMax - this._logMin;
    }

    public double sliderToModel(int n) {
        double d = 0.0;
        if (n == this.getSliderMin()) {
            d = this.getModelMin();
        } else if (n == this.getSliderMax()) {
            d = this.getModelMax();
        } else {
            int n2 = this.getSliderMax() - this.getSliderMin();
            double d2 = this._logRange / (double)n2;
            double d3 = (double)(n - this.getSliderMin()) * d2;
            double d4 = this._logMin + d3;
            d = d4 >= 0.0 ? Math.pow(10.0, d4) / this._scalingFactor : -Math.pow(10.0, -d4) / this._scalingFactor;
            if (d < this.getModelMin()) {
                d = this.getModelMin();
                System.err.println("WARNING: LogarithmicSliderStrategy.sliderToModel, modelValue too small, clamping to " + d);
            } else if (d > this.getModelMax()) {
                d = this.getModelMax();
                System.err.println("WARNING: LogarithmicSliderStrategy.sliderToModel, modelValue too big, clamping to " + d);
            }
        }
        return d;
    }

    public int modelToSlider(double d) {
        int n = 0;
        if (d == this.getModelMin()) {
            n = this.getSliderMin();
        } else if (d == this.getModelMax()) {
            n = this.getSliderMax();
        } else {
            int n2 = this.getSliderMax() - this.getSliderMin();
            double d2 = LogarithmicMappingStrategy.adjustedLog10(d * this._scalingFactor);
            n = this.getSliderMin() + (int)((double)n2 * (d2 - this._logMin) / this._logRange);
            if (n < this.getSliderMin()) {
                n = this.getSliderMin();
                System.err.println("WARNING: LogarithmicSliderStrategy.modelToSlider, sliderValue too small, clamping to " + n);
            } else if (n > this.getSliderMax()) {
                n = this.getSliderMax();
                System.err.println("WARNING: LogarithmicSliderStrategy.modelToSlider, sliderValue too big, clamping to " + n);
            }
        }
        return n;
    }

    private static double adjustedLog10(double d) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = LogarithmicMappingStrategy.log10(d);
        } else if (d < 0.0) {
            d2 = -LogarithmicMappingStrategy.log10(-d);
        }
        return d2;
    }

    private static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }
}

