/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

public class DoubleRange {
    private final double _min;
    private final double _max;
    private final double _default;
    private final int _significantDecimalPlaces;

    public DoubleRange(double d, double d2) {
        this(d, d2, d, Integer.MAX_VALUE);
    }

    public DoubleRange(double d, double d2, double d3) {
        this(d, d2, d3, Integer.MAX_VALUE);
    }

    public DoubleRange(double d, double d2, double d3, int n) {
        if (!(d <= d2)) {
            throw new IllegalArgumentException("min must be <= max: min = " + d + ", max = " + d2);
        }
        if (d3 < d || d3 > d2) {
            throw new IllegalArgumentException("defaultValue out of range: min = " + d + ", max = " + d2 + ", defaultValue = " + d3);
        }
        if (n < 0) {
            throw new IllegalArgumentException("significantDecimalPlaces < 0: " + n);
        }
        this._min = d;
        this._max = d2;
        this._default = d3;
        this._significantDecimalPlaces = n;
    }

    public DoubleRange(DoubleRange doubleRange) {
        this(doubleRange.getMin(), doubleRange.getMax(), doubleRange.getDefault(), doubleRange.getSignificantDecimalPlaces());
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getDefault() {
        return this._default;
    }

    public int getSignificantDecimalPlaces() {
        return this._significantDecimalPlaces;
    }

    public boolean contains(double d) {
        return d >= this._min && d <= this._max;
    }

    public double getLength() {
        return this._max - this._min;
    }

    public String toString() {
        return "min=" + this._min + ", max=" + this._max + ", default=" + this._default + ", significantDecimalPlaces=" + this._significantDecimalPlaces;
    }
}

