/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import edu.colorado.phet.common.phetcommon.util.function.Function1;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimSharingConfig {
    public static final Function1<Character, Boolean> DIGITS = new Function1<Character, Boolean>(){

        @Override
        public Boolean apply(Character c) {
            return Character.isDigit(c.charValue());
        }
    };
    public static final Function1<Character, Boolean> WORDS = new Function1<Character, Boolean>(){

        @Override
        public Boolean apply(Character c) {
            return Character.isLetterOrDigit(c.charValue()) || Character.isWhitespace(c.charValue()) || c.charValue() == '.';
        }
    };
    public static final Function1<Character, Boolean> NO_WHITESPACE = new Function1<Character, Boolean>(){

        @Override
        public Boolean apply(Character c) {
            return !c.toString().equals(" ");
        }
    };
    public static final SimSharingConfig INTERVIEWS = new SimSharingConfig("interviews", true, false, false, false);
    public static final SimSharingConfig USB_DRIVE = new SimSharingConfig("usb-drive", false, true, false, false, false, NO_WHITESPACE);
    public static final SimSharingConfig USB_DRIVE_AND_GROUP_NUMBER = new SimSharingConfig("usb-drive-and-group-number", false, true, false, true, true, "Enter your group number:", NO_WHITESPACE);
    public static final SimSharingConfig COLORADO_CONFIG = new SimSharingConfig("colorado", false, false, true, true, true, "Enter your computer number:");
    public static final SimSharingConfig UTAH_CONFIG = new SimSharingConfig("utah", false, false, true, true, false, "Enter your audio recorder number:");
    public static final SimSharingConfig DALLAS_JAN_2012 = new SimSharingConfig("dallas-jan-2012", true, true, false, false);
    public static final SimSharingConfig DALLAS_JAN_2012_ID = new SimSharingConfig("dallas-jan-2012-id", true, true, false, false);
    public static final SimSharingConfig ABS_SPRING_2012 = new SimSharingConfig("acid-base-solutions-spring-2012", true, true, false, false);
    public static final SimSharingConfig FARADAY_SPRING_2012 = new SimSharingConfig("faraday-spring-2012", false, true, false, false);
    public static final SimSharingConfig BALANCING_ACT_SPRING_2012 = new SimSharingConfig("balancing-act-spring-2012", true, false, true, true, true, "Please enter your user ID:", WORDS);
    public static final SimSharingConfig MOLECULE_SHAPED_FEB_2012 = new SimSharingConfig("molecule-shapes-feb-2012", true, true, false, false);
    public static final SimSharingConfig LOAD_TESTING = new SimSharingConfig("load-testing", false, true, false, false);
    public static final SimSharingConfig DEFAULT = new SimSharingConfig("default", false, false, false, false, false, "");
    public static final SimSharingConfig RPAL_APRIL_2012 = new SimSharingConfig("rpal-april-2012", true, false, false, false);
    public static final SimSharingConfig CCK_UBC_SPRING_2013 = new SimSharingConfig("cck-ubc-spring-2013", true, false, false, true, true, "Please enter your assigned ID:");
    private static final HashMap<String, SimSharingConfig> CONFIG_MAP = new HashMap();
    public final String studyName;
    public final boolean requestId;
    public final boolean idRequired;
    public final String idPrompt;
    public final boolean sendToLogFile;
    public final boolean sendToLogFileNearJAR;
    public final boolean sendToServer;
    public final boolean collectIPAddress = false;
    public final Function1<Character, Boolean> characterValidation;

    private static void addConfig(SimSharingConfig simSharingConfig) {
        assert (CONFIG_MAP.get(simSharingConfig.studyName) == null);
        CONFIG_MAP.put(simSharingConfig.studyName, simSharingConfig);
    }

    public static SimSharingConfig getConfig(String string) {
        SimSharingConfig simSharingConfig = CONFIG_MAP.get(string);
        if (simSharingConfig == null) {
            simSharingConfig = DEFAULT;
        }
        return simSharingConfig;
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, bl, false, bl2, bl3, bl4, DIGITS);
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Function1<Character, Boolean> function1) {
        this(string, bl, bl2, bl3, bl4, bl5, null, function1);
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2) {
        this(string, bl, bl2, bl3, bl4, bl5, string2, DIGITS);
    }

    protected SimSharingConfig(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2, Function1<Character, Boolean> function1) {
        this.studyName = string;
        this.sendToLogFile = bl;
        this.sendToLogFileNearJAR = bl2;
        this.sendToServer = bl3;
        this.requestId = bl4;
        this.idPrompt = string2;
        this.idRequired = bl5;
        this.characterValidation = function1;
    }

    static {
        SimSharingConfig.addConfig(INTERVIEWS);
        SimSharingConfig.addConfig(USB_DRIVE);
        SimSharingConfig.addConfig(USB_DRIVE_AND_GROUP_NUMBER);
        SimSharingConfig.addConfig(COLORADO_CONFIG);
        SimSharingConfig.addConfig(UTAH_CONFIG);
        SimSharingConfig.addConfig(DALLAS_JAN_2012);
        SimSharingConfig.addConfig(DALLAS_JAN_2012_ID);
        SimSharingConfig.addConfig(ABS_SPRING_2012);
        SimSharingConfig.addConfig(FARADAY_SPRING_2012);
        SimSharingConfig.addConfig(BALANCING_ACT_SPRING_2012);
        SimSharingConfig.addConfig(MOLECULE_SHAPED_FEB_2012);
        SimSharingConfig.addConfig(LOAD_TESTING);
        SimSharingConfig.addConfig(RPAL_APRIL_2012);
        SimSharingConfig.addConfig(CCK_UBC_SPRING_2013);
    }
}

