/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.view.ClockControlPanel;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.HelpPanel;
import edu.colorado.phet.common.phetcommon.view.LogoPanel;
import edu.colorado.phet.common.phetcommon.view.ModulePanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class Module
implements Resettable {
    private String name;
    private BaseModel model;
    private IClock clock;
    private boolean active = false;
    private boolean clockRunningWhenActive = true;
    private ClockAdapter moduleRunner;
    private ModulePanel modulePanel;
    private ArrayList listeners = new ArrayList();

    public Module(String string, IClock iClock) {
        this(string, iClock, false);
    }

    public Module(String string, IClock iClock, boolean bl) {
        this.name = string;
        this.clock = iClock;
        this.setModel(new BaseModel());
        this.modulePanel = new ModulePanel();
        this.setClockControlPanel(this.createClockControlPanel(iClock));
        this.setLogoPanel(new LogoPanel());
        this.setHelpPanel(new HelpPanel(this));
        this.moduleRunner = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                Module.this.handleClockTick(clockEvent);
            }
        };
        iClock.addClockListener(this.moduleRunner);
        this.clockRunningWhenActive = !bl;
        this.updateHelpPanelVisible();
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        return new ClockControlPanel(iClock);
    }

    public IClock getClock() {
        return this.clock;
    }

    protected void handleClockTick(ClockEvent clockEvent) {
        this.handleUserInput();
        this.model.update(clockEvent);
        this.updateGraphics(clockEvent);
    }

    public void setClockRunningWhenActive(boolean bl) {
        this.clockRunningWhenActive = bl;
        if (this.isActive()) {
            if (this.clockRunningWhenActive) {
                this.clock.start();
            } else {
                this.clock.pause();
            }
        }
    }

    public boolean getClockRunningWhenActive() {
        if (this.isActive()) {
            this.clockRunningWhenActive = this.clock.isRunning();
        }
        return this.clockRunningWhenActive;
    }

    public void setModel(BaseModel baseModel) {
        this.model = baseModel;
    }

    public BaseModel getModel() {
        return this.model;
    }

    public ModulePanel getModulePanel() {
        return this.modulePanel;
    }

    protected void setSimulationPanel(JComponent jComponent) {
        Window window;
        this.modulePanel.setSimulationPanel(jComponent);
        if (jComponent != null && (window = SwingUtilities.getWindowAncestor(jComponent)) != null) {
            window.invalidate();
            window.validate();
            window.doLayout();
        }
    }

    public JComponent getSimulationPanel() {
        return this.modulePanel.getSimulationPanel();
    }

    protected void setClockControlPanel(JComponent jComponent) {
        this.modulePanel.setClockControlPanel(jComponent);
    }

    public JComponent getClockControlPanel() {
        return this.modulePanel.getClockControlPanel();
    }

    protected void setLogoPanel(JComponent jComponent) {
        this.modulePanel.setLogoPanel(jComponent);
    }

    protected void setControlPanel(JComponent jComponent) {
        this.modulePanel.setControlPanel(jComponent);
    }

    public ControlPanel getControlPanel() {
        ControlPanel controlPanel = null;
        JComponent jComponent = this.modulePanel.getControlPanel();
        if (jComponent != null && jComponent instanceof ControlPanel) {
            controlPanel = (ControlPanel)jComponent;
        }
        return controlPanel;
    }

    protected void setHelpPanel(JComponent jComponent) {
        this.modulePanel.setHelpPanel(jComponent);
    }

    public HelpPanel getHelpPanel() {
        HelpPanel helpPanel = null;
        JComponent jComponent = this.modulePanel.getHelpPanel();
        if (jComponent != null && jComponent instanceof HelpPanel) {
            helpPanel = (HelpPanel)jComponent;
        }
        return helpPanel;
    }

    public boolean hasHelp() {
        return false;
    }

    public boolean hasMegaHelp() {
        return false;
    }

    public void setHelpEnabled(boolean bl) {
        HelpPanel helpPanel = this.getHelpPanel();
        if (helpPanel != null) {
            helpPanel.setHelpEnabled(bl);
        }
    }

    public boolean isHelpEnabled() {
        boolean bl = false;
        HelpPanel helpPanel = this.getHelpPanel();
        if (helpPanel != null) {
            bl = helpPanel.isHelpEnabled();
        }
        return bl;
    }

    public void showMegaHelp() {
    }

    public void setLogoPanelVisible(boolean bl) {
        JComponent jComponent = this.modulePanel.getLogoPanel();
        if (jComponent != null) {
            jComponent.setVisible(bl);
        }
    }

    public boolean isLogoPanelVisible() {
        boolean bl = false;
        JComponent jComponent = this.modulePanel.getLogoPanel();
        if (jComponent != null) {
            bl = jComponent.isVisible();
        }
        return bl;
    }

    public void activate() {
        if (!this.isWellFormed()) {
            throw new RuntimeException("Module missing important data, module=" + this);
        }
        if (this.clockRunningWhenActive) {
            this.clock.start();
        }
        this.updateHelpPanelVisible();
        this.active = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).activated();
        }
    }

    protected void updateHelpPanelVisible() {
        HelpPanel helpPanel = this.getHelpPanel();
        if (helpPanel != null) {
            helpPanel.setVisible(this.hasHelp());
        }
    }

    public IUserComponent getTabUserComponent() {
        return UserComponents.tab;
    }

    public void deactivate() {
        this.clockRunningWhenActive = this.getClock().isRunning();
        this.clock.pause();
        this.active = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).deactivated();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWellFormed() {
        boolean bl = true;
        bl &= this.getModel() != null;
        return bl &= this.getSimulationPanel() != null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name=" + this.name + ", model=" + this.model + ", simulationPanel=" + this.getSimulationPanel();
    }

    public void setReferenceSize() {
    }

    protected void handleUserInput() {
    }

    public void updateGraphics(ClockEvent clockEvent) {
    }

    public void setControlPanelBackground(Color color) {
        if (this.getControlPanel() != null) {
            Class[] classArray = new Class[]{JTextComponent.class};
            this.setControlPanelBackground(color, classArray);
        }
    }

    public void setControlPanelBackground(Color color, Class[] classArray) {
        if (this.getControlPanel() != null) {
            SwingUtils.setBackgroundDeep(this.getControlPanel(), color, classArray, false);
        }
    }

    public void setClockControlPanelBackground(Color color) {
        if (this.getClockControlPanel() != null) {
            Class[] classArray = new Class[]{JTextComponent.class};
            this.setClockControlPanelBackground(color, classArray);
        }
    }

    public void setClockControlPanelBackground(Color color, Class[] classArray) {
        if (this.getClockControlPanel() != null) {
            SwingUtils.setBackgroundDeep(this.getClockControlPanel(), color, classArray, false);
        }
    }

    public void setHelpPanelBackground(Color color) {
        if (this.getHelpPanel() != null) {
            Class[] classArray = new Class[]{JTextComponent.class};
            this.setHelpPanelBackground(color, classArray);
        }
    }

    public void setHelpPanelBackground(Color color, Class[] classArray) {
        if (this.getHelpPanel() != null) {
            SwingUtils.setBackgroundDeep(this.getHelpPanel(), color, classArray, false);
        }
    }

    public void reset() {
    }

    public static interface Listener {
        public void activated();

        public void deactivated();
    }
}

