/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.jfreechartphet;

import edu.colorado.phet.common.jfreechartphet.PhetHistogramSeries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class PhetHistogramDataset
extends AbstractIntervalXYDataset
implements Serializable,
Cloneable,
IntervalXYDataset,
PublicCloneable {
    private HistogramType histogramType;
    private List seriesList;

    public PhetHistogramDataset() {
        this(HistogramType.FREQUENCY);
    }

    public PhetHistogramDataset(HistogramType histogramType) {
        if (histogramType == null) {
            throw new IllegalArgumentException("histogramType is null");
        }
        this.histogramType = histogramType;
        this.seriesList = new ArrayList();
    }

    public PhetHistogramSeries getSeries(int n) {
        return (PhetHistogramSeries)this.seriesList.get(n);
    }

    public int addSeries(PhetHistogramSeries phetHistogramSeries) {
        this.seriesList.add(phetHistogramSeries);
        phetHistogramSeries.addChangeListener(this);
        this.fireDatasetChanged();
        return this.seriesList.indexOf(phetHistogramSeries);
    }

    public void removeSeries(PhetHistogramSeries phetHistogramSeries) {
        this.seriesList.remove(phetHistogramSeries);
        phetHistogramSeries.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public Comparable getSeriesKey(int n) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        return phetHistogramSeries.getKey();
    }

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public int getItemCount(int n) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        return phetHistogramSeries.getNumberOfBins();
    }

    public Number getX(int n, int n2) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        double d = phetHistogramSeries.getStartBoundary(n2);
        double d2 = phetHistogramSeries.getEndBoundary(n2);
        double d3 = (d + d2) / 2.0;
        return new Double(d3);
    }

    public Number getY(int n, int n2) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        double d = phetHistogramSeries.getNumberOfObservations();
        double d2 = phetHistogramSeries.getNumberOfObservations(n2);
        double d3 = phetHistogramSeries.getBinWidth();
        double d4 = 0.0;
        if (this.histogramType == HistogramType.FREQUENCY) {
            d4 = d2;
        } else if (this.histogramType == HistogramType.RELATIVE_FREQUENCY) {
            d4 = d2 / d;
        } else if (this.histogramType == HistogramType.SCALE_AREA_TO_1) {
            d4 = d2 / (d3 * d);
        } else {
            throw new IllegalStateException("unsupported HistogramType: " + this.histogramType);
        }
        return new Double(d4);
    }

    public Number getStartX(int n, int n2) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        double d = phetHistogramSeries.getStartBoundary(n2);
        return new Double(d);
    }

    public Number getEndX(int n, int n2) {
        PhetHistogramSeries phetHistogramSeries = this.getSeries(n);
        double d = phetHistogramSeries.getEndBoundary(n2);
        return new Double(d);
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PhetHistogramDataset)) {
            return false;
        }
        PhetHistogramDataset phetHistogramDataset = (PhetHistogramDataset)object;
        if (!ObjectUtilities.equal(this.histogramType, phetHistogramDataset.histogramType)) {
            return false;
        }
        return ObjectUtilities.equal(this.seriesList, phetHistogramDataset.seriesList);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

