/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCConstants;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.charts.FourierSumPlot;
import edu.colorado.phet.opticalquantumcontrol.charts.PulseChart;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.view.LightSpigot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;

public class OutputPulseView
extends GraphicLayerSet
implements SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(535, 190);
    private static final Color BACKGROUND_COLOR = OQCConstants.COMMON_GRAY;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.0, 0.5, 1.0);
    private static final Dimension CHART_SIZE = new Dimension(440, 135);
    private static final Stroke USER_SUM_STROKE = new BasicStroke(1.0f);
    private static final Color USER_SUM_COLOR = Color.BLACK;
    private static final Stroke RANDOM_SUM_STROKE = new BasicStroke(3.0f);
    public static final Color RANDOM_SUM_COLOR = OQCConstants.OUTPUT_PULSE_COLOR;
    private FourierSeries _userFourierSeries;
    private FourierSeries _outputFourierSeries;
    private PhetShapeGraphic _backgroundGraphic;
    private HTMLGraphic _titleGraphic;
    private PulseChart _chartGraphic;
    private FourierSumPlot _userSumPlot;
    private FourierSumPlot _outputSumPlot;

    public OutputPulseView(Component component, FourierSeries fourierSeries, FourierSeries fourierSeries2) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._userFourierSeries = fourierSeries;
        this._userFourierSeries.addObserver(this);
        this._outputFourierSeries = fourierSeries2;
        this._outputFourierSeries.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new RoundRectangle2D.Double(0.0, 0.0, OutputPulseView.BACKGROUND_SIZE.width, OutputPulseView.BACKGROUND_SIZE.height, 20.0, 20.0));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this.addGraphic(this._backgroundGraphic, 1.0);
        this._backgroundGraphic.setLocation(0, 0);
        LightSpigot lightSpigot = new LightSpigot(component);
        lightSpigot.scale(1.0, -1.0);
        lightSpigot.setLocation(1, OutputPulseView.BACKGROUND_SIZE.height - 20);
        this.addGraphic(lightSpigot, 2.0);
        String string = OQCResources.OUTPUT_PULSE;
        this._titleGraphic = new HTMLGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.setRegistrationPoint(this._titleGraphic.getWidth() / 2, 0);
        this._titleGraphic.setLocation(OutputPulseView.BACKGROUND_SIZE.width / 2, 5);
        this.addGraphic(this._titleGraphic, 3.0);
        this._chartGraphic = new PulseChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(this._chartGraphic, 4.0);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(35, 35);
        this._chartGraphic.setXAxisTitle(OQCResources.PULSE_X_AXIS_LABEL);
        this._outputSumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, this._outputFourierSeries);
        this._outputSumPlot.setUseCosines(true);
        this._outputSumPlot.setPeriod(1.0);
        this._outputSumPlot.setYScale(0.13);
        this._outputSumPlot.setPixelsPerPoint(1.0);
        this._outputSumPlot.setStroke(RANDOM_SUM_STROKE);
        this._outputSumPlot.setBorderColor(RANDOM_SUM_COLOR);
        this._chartGraphic.addDataSetGraphic(this._outputSumPlot);
        this._chartGraphic.autoscaleY(this._outputSumPlot.getMaxAmplitude() * 1.5);
        this._userSumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, this._userFourierSeries);
        this._userSumPlot.setUseCosines(true);
        this._userSumPlot.setPeriod(1.0);
        this._userSumPlot.setYScale(0.13);
        this._userSumPlot.setPixelsPerPoint(1.0);
        this._userSumPlot.setStroke(USER_SUM_STROKE);
        this._userSumPlot.setBorderColor(USER_SUM_COLOR);
        this._chartGraphic.addDataSetGraphic(this._userSumPlot);
        this.setIgnoreMouse(true);
    }

    public void update() {
        if (this.isVisible()) {
            this._userSumPlot.updateDataSet();
            this._outputSumPlot.updateDataSet();
            this._chartGraphic.autoscaleY(this._outputSumPlot.getMaxAmplitude() * 1.5);
        }
    }
}

