/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.module.OQCModule;
import edu.colorado.phet.opticalquantumcontrol.view.MagnifyingGlass;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Random;

public class MoleculeAnimation
extends CompositePhetGraphic
implements ModelElement,
SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(250, 250);
    private static final Point MOLECULE_POINT = new Point(-70, 300);
    private OQCModule _module;
    private FourierSeries _userFourierSeries;
    private FourierSeries _outputFourierSeries;
    private PhetShapeGraphic _animationFrame;
    private CompositePhetGraphic _moleculeGraphic;
    private PhetImageGraphic _moleculePart1;
    private PhetImageGraphic _moleculePart2;
    private PhetImageGraphic _moleculePart3;
    private HTMLGraphic _closenessGraphic;
    private String _closenessFormat;
    private PhetImageGraphic _explosionGraphic;
    private Point _moleculeHome;
    private double _closeness;
    private Random _random;
    private double _dx1;
    private double _dy1;
    private double _dx2;
    private double _dy2;
    private double _dx3;
    private double _dy3;
    private boolean _isExploding;
    private boolean _animationDone;
    private boolean _isAdjusting;

    public MoleculeAnimation(Component component, OQCModule oQCModule, FourierSeries fourierSeries, FourierSeries fourierSeries2) {
        super(component);
        this._module = oQCModule;
        this._userFourierSeries = fourierSeries;
        this._outputFourierSeries = fourierSeries2;
        this._userFourierSeries.addObserver(this);
        this._outputFourierSeries.addObserver(this);
        this.setIgnoreMouse(true);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._random = new Random();
        this._isAdjusting = false;
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new Rectangle(0, 0, MoleculeAnimation.BACKGROUND_SIZE.width, MoleculeAnimation.BACKGROUND_SIZE.height));
        phetShapeGraphic.setColor(new Color(215, 215, 215));
        this.addGraphic(phetShapeGraphic);
        Object object = new float[]{3.0f, 3.0f};
        Object[] objectArray = new BasicStroke(1.0f, 2, 2, 0.0f, (float[])object, 0.0f);
        Object object2 = new BasicStroke(1.0f, 2, 2, 0.0f, (float[])object, 3.0f);
        Shape shape = new GeneralPath();
        shape.moveTo(0.0f, 0.0f);
        shape.lineTo(MoleculeAnimation.MOLECULE_POINT.x, MoleculeAnimation.MOLECULE_POINT.y);
        PhetShapeGraphic phetShapeGraphic2 = new PhetShapeGraphic(component);
        phetShapeGraphic2.setShape(shape);
        phetShapeGraphic2.setColor(Color.WHITE);
        phetShapeGraphic2.setStroke((Stroke)objectArray);
        this.addGraphic(phetShapeGraphic2);
        PhetGraphic phetGraphic = new PhetShapeGraphic(component);
        ((PhetShapeGraphic)phetGraphic).setShape(shape);
        ((PhetShapeGraphic)phetGraphic).setColor(Color.BLACK);
        ((PhetShapeGraphic)phetGraphic).setStroke((Stroke)object2);
        this.addGraphic(phetGraphic);
        shape = new GeneralPath();
        shape.moveTo(MoleculeAnimation.BACKGROUND_SIZE.width, MoleculeAnimation.BACKGROUND_SIZE.height);
        shape.lineTo(MoleculeAnimation.MOLECULE_POINT.x, MoleculeAnimation.MOLECULE_POINT.y);
        phetShapeGraphic2 = new PhetShapeGraphic(component);
        phetShapeGraphic2.setShape(shape);
        phetShapeGraphic2.setColor(Color.WHITE);
        phetShapeGraphic2.setStroke((Stroke)objectArray);
        this.addGraphic(phetShapeGraphic2);
        phetGraphic = new PhetShapeGraphic(component);
        ((PhetShapeGraphic)phetGraphic).setShape(shape);
        ((PhetShapeGraphic)phetGraphic).setColor(Color.BLACK);
        ((PhetShapeGraphic)phetGraphic).setStroke((Stroke)object2);
        this.addGraphic(phetGraphic);
        shape = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
        phetShapeGraphic2 = new PhetShapeGraphic(component);
        phetShapeGraphic2.setShape(shape);
        phetShapeGraphic2.setStroke(new BasicStroke(1.0f));
        phetShapeGraphic2.setBorderColor(Color.WHITE);
        phetShapeGraphic2.centerRegistrationPoint();
        phetShapeGraphic2.setLocation(MOLECULE_POINT);
        this.addGraphic(phetShapeGraphic2);
        phetGraphic = new MagnifyingGlass(component);
        phetGraphic.setLocation(MoleculeAnimation.MOLECULE_POINT.x + 31, MoleculeAnimation.MOLECULE_POINT.y + 2);
        phetGraphic.rotate(Math.toRadians(140.0));
        this.addGraphic(phetGraphic);
        this._animationFrame = new PhetShapeGraphic(component);
        object = new Rectangle(0, 0, MoleculeAnimation.BACKGROUND_SIZE.width - 30, MoleculeAnimation.BACKGROUND_SIZE.height - 45);
        this._animationFrame.setShape((Shape)object);
        this._animationFrame.setColor(Color.BLACK);
        this._animationFrame.setBorderColor(Color.BLACK);
        this._animationFrame.setStroke(new BasicStroke(1.0f));
        this.addGraphic(this._animationFrame);
        this._animationFrame.setRegistrationPoint(this._animationFrame.getWidth() / 2, 0);
        this._animationFrame.setLocation(MoleculeAnimation.BACKGROUND_SIZE.width / 2, 15);
        this._closenessGraphic = new HTMLGraphic(component);
        this._closenessGraphic.setColor(Color.BLACK);
        this._closenessGraphic.setFont(new PhetFont(0, 18));
        this._closenessFormat = OQCResources.CLOSENESS_READOUT;
        objectArray = new Object[]{"-000"};
        object2 = MessageFormat.format(this._closenessFormat, objectArray);
        this._closenessGraphic.setHTML((String)object2);
        this.addGraphic(this._closenessGraphic);
        this._closenessGraphic.setRegistrationPoint(this._closenessGraphic.getWidth() / 2, this._closenessGraphic.getHeight());
        this._closenessGraphic.setLocation(MoleculeAnimation.BACKGROUND_SIZE.width / 2, MoleculeAnimation.BACKGROUND_SIZE.height - 5);
        this._explosionGraphic = new PhetImageGraphic(component, OQCResources.KABOOM_IMAGE);
        this._explosionGraphic.setRegistrationPoint(this._explosionGraphic.getWidth() / 2, 0);
        this._explosionGraphic.setLocation(this._animationFrame.getLocation());
        this.addGraphic(this._explosionGraphic);
        this._moleculeGraphic = new CompositePhetGraphic(component);
        this._moleculePart1 = new PhetImageGraphic(component);
        this._moleculePart2 = new PhetImageGraphic(component);
        this._moleculePart3 = new PhetImageGraphic(component);
        this._moleculeGraphic.addGraphic(this._moleculePart1);
        this._moleculeGraphic.addGraphic(this._moleculePart2);
        this._moleculeGraphic.addGraphic(this._moleculePart3);
        this._moleculeHome = new Point(30, 15);
        this._moleculeGraphic.setLocation(this._moleculeHome);
        this.addGraphic(this._moleculeGraphic);
        this.reset();
        this.update();
    }

    public void reset() {
        this._animationDone = false;
        this._isExploding = false;
        this.setCloseness(0.0);
        this._explosionGraphic.setVisible(false);
        this._moleculeGraphic.setLocation(this._moleculeHome);
        this._moleculePart1.setLocation(0, 0);
        this._moleculePart2.setLocation(0, 0);
        this._moleculePart3.setLocation(0, 0);
    }

    public void setMolecule(int n) {
        BufferedImage bufferedImage = OQCResources.getImage("molecule" + n + "_part1.png");
        BufferedImage bufferedImage2 = OQCResources.getImage("molecule" + n + "_part2.png");
        BufferedImage bufferedImage3 = OQCResources.getImage("molecule" + n + "_part3.png");
        this._moleculePart1.setImage(bufferedImage);
        this._moleculePart2.setImage(bufferedImage2);
        this._moleculePart3.setImage(bufferedImage3);
    }

    private void setCloseness(double d) {
        this._closeness = d;
        int n = (int)(100.0 * d);
        Object[] objectArray = new Object[]{new Integer(n)};
        String string = MessageFormat.format(this._closenessFormat, objectArray);
        this._closenessGraphic.setHTML(string);
    }

    public void stepInTime(double d) {
        if (!this._animationDone) {
            if (this._isExploding) {
                this._moleculePart1.setLocation((int)((double)this._moleculePart1.getX() + this._dx1), (int)((double)this._moleculePart1.getY() + this._dy1));
                this._moleculePart2.setLocation((int)((double)this._moleculePart2.getX() + this._dx2), (int)((double)this._moleculePart2.getY() + this._dy2));
                this._moleculePart3.setLocation((int)((double)this._moleculePart3.getX() + this._dx3), (int)((double)this._moleculePart3.getY() + this._dy3));
                this._dx1 += this._dx1 * 0.1;
                this._dy1 += this._dy1 * 0.1;
                this._dx2 += this._dx2 * 0.1;
                this._dy2 += this._dy2 * 0.1;
                this._dx3 += this._dx3 * 0.1;
                this._dy3 += this._dy3 * 0.1;
                if (this._moleculeGraphic.getClip() != null) {
                    if (Math.abs(this._moleculePart1.getX()) > 2 * this._animationFrame.getWidth() && Math.abs(this._moleculePart1.getY()) > 2 * this._animationFrame.getHeight()) {
                        this._animationDone = true;
                        this.gameOver();
                    }
                } else if (Math.abs(this._moleculePart1.getX()) > 2048 && Math.abs(this._moleculePart1.getY()) > 1536) {
                    this._animationDone = true;
                    this.gameOver();
                }
            } else if (this._closeness >= 0.95) {
                this._explosionGraphic.setVisible(true);
                this._isExploding = true;
                double d2 = Math.random() * Math.PI * 2.0;
                double d3 = d2 + Math.toRadians(120.0);
                double d4 = d3 + Math.toRadians(120.0);
                this._dx1 = this._closeness * this._closeness * 10.0 * Math.cos(d2);
                this._dy1 = this._closeness * this._closeness * 10.0 * Math.sin(d2);
                this._dx2 = this._closeness * this._closeness * 10.0 * Math.cos(d3);
                this._dy2 = this._closeness * this._closeness * 10.0 * Math.sin(d3);
                this._dx3 = this._closeness * this._closeness * 10.0 * Math.cos(d4);
                this._dy3 = this._closeness * this._closeness * 10.0 * Math.sin(d4);
            } else if (this._closeness > 0.0) {
                double d5 = this._random.nextGaussian() * this._closeness * this._closeness * 10.0 * (double)(Math.random() > 0.5 ? 1 : -1);
                double d6 = Math.random() * Math.PI * 2.0;
                double d7 = d5 * Math.cos(d6);
                double d8 = d5 * Math.sin(d6);
                this._moleculeGraphic.setLocation((int)((double)this._moleculeHome.x + d7), (int)((double)this._moleculeHome.y + d8));
            }
        }
    }

    private void gameOver() {
        this._isAdjusting = true;
        PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
        String string = OQCResources.WIN_DIALOG_MESSAGE;
        String string2 = OQCResources.WIN_DIALOG_TITLE;
        PhetOptionPane.showMessageDialog(phetFrame, string, string2, -1);
        this._module.newGame();
        this._isAdjusting = false;
    }

    public void update() {
        if (!this._isAdjusting && !this._isExploding) {
            double d = 0.0;
            double d2 = 0.0;
            int n = this._userFourierSeries.getNumberOfHarmonics();
            for (int i = 0; i < n; ++i) {
                double d3 = this._userFourierSeries.getHarmonic(i).getAmplitude();
                double d4 = this._outputFourierSeries.getHarmonic(i).getAmplitude();
                d += Math.pow(Math.abs(d3 - d4), 2.0);
                d2 += Math.pow(1.0 + Math.abs(d4), 2.0);
            }
            if (d2 != 0.0) {
                double d5 = 1.0 - Math.sqrt(d) / Math.sqrt(d2);
                this.setCloseness(d5);
                if (d5 >= 0.95) {
                    this._userFourierSeries.removeObserver(this);
                    this._userFourierSeries.notifyObservers();
                    this._userFourierSeries.addObserver(this);
                }
            }
        }
    }
}

