/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCConstants;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.charts.FourierSumPlot;
import edu.colorado.phet.opticalquantumcontrol.charts.PulseChart;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.view.LightSpigot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;

public class InputPulseView
extends GraphicLayerSet {
    private static final Dimension BACKGROUND_SIZE = new Dimension(535, 190);
    private static final Color BACKGROUND_COLOR = OQCConstants.COMMON_GRAY;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.05, 0.5, 1.05);
    private static final Dimension CHART_SIZE = new Dimension(440, 135);
    private static final Stroke WAVE_STROKE = new BasicStroke(1.0f);
    private static final Color WAVE_COLOR = Color.BLACK;

    public InputPulseView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new RoundRectangle2D.Double(0.0, 0.0, InputPulseView.BACKGROUND_SIZE.width, InputPulseView.BACKGROUND_SIZE.height, 20.0, 20.0));
        phetShapeGraphic.setPaint(BACKGROUND_COLOR);
        this.addGraphic(phetShapeGraphic, 1.0);
        phetShapeGraphic.setLocation(0, 0);
        LightSpigot lightSpigot = new LightSpigot(component);
        lightSpigot.setLocation(1, 20);
        this.addGraphic(lightSpigot, 2.0);
        String string = OQCResources.INPUT_PULSE;
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        hTMLGraphic.setRegistrationPoint(hTMLGraphic.getWidth() / 2, 0);
        hTMLGraphic.setLocation(InputPulseView.BACKGROUND_SIZE.width / 2, 5);
        this.addGraphic(hTMLGraphic, 3.0);
        PulseChart pulseChart = new PulseChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(pulseChart, 4.0);
        pulseChart.setRegistrationPoint(0, 0);
        pulseChart.setLocation(35, 35);
        pulseChart.setXAxisTitle(OQCResources.PULSE_X_AXIS_LABEL);
        FourierSumPlot fourierSumPlot = new FourierSumPlot(component, (Chart)pulseChart, fourierSeries);
        fourierSumPlot.setPixelsPerPoint(1.0);
        fourierSumPlot.setStroke(WAVE_STROKE);
        fourierSumPlot.setStrokeColor(WAVE_COLOR);
        fourierSumPlot.setUseCosines(true);
        fourierSumPlot.setYScale(0.13);
        pulseChart.addDataSetGraphic(fourierSumPlot);
        this.setIgnoreMouse(true);
    }
}

