/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;

public class CheatPanel
extends GraphicLayerSet
implements SimpleObserver {
    private static final DecimalFormat CHEAT_FORMAT = new DecimalFormat("0.00");
    private static final Font TITLE_FONT = new PhetFont(1, 14);
    private static final Font VALUES_FONT = new PhetFont(0, 12);
    private FourierSeries _outputFourierSeries;
    private ArrayList _valueGraphics;

    public CheatPanel(Component component, FourierSeries fourierSeries) {
        super(component);
        this._outputFourierSeries = fourierSeries;
        this._outputFourierSeries.addObserver(this);
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component);
        hTMLGraphic.setIgnoreMouse(true);
        hTMLGraphic.setColor(Color.BLACK);
        hTMLGraphic.setFont(TITLE_FONT);
        hTMLGraphic.setHTML(OQCResources.CHEAT_DIALOG_LABEL);
        hTMLGraphic.setLocation(35, 5);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setIgnoreMouse(true);
        phetShapeGraphic.setColor(Color.LIGHT_GRAY);
        phetShapeGraphic.setBorderColor(Color.DARK_GRAY);
        phetShapeGraphic.setStroke(new BasicStroke(1.0f));
        int n = (int)Math.max(275.0, hTMLGraphic.getLocation().getX() + (double)hTMLGraphic.getWidth() + 10.0);
        phetShapeGraphic.setShape(new Rectangle(0, 0, n, 80));
        this.addGraphic(phetShapeGraphic);
        this.addGraphic(hTMLGraphic);
        this._valueGraphics = new ArrayList();
        int n2 = 30;
        int n3 = this._outputFourierSeries.getNumberOfHarmonics();
        for (int i = 0; i < n3; ++i) {
            double d = this._outputFourierSeries.getHarmonic(i).getAmplitude();
            String string = CHEAT_FORMAT.format(d);
            HTMLGraphic hTMLGraphic2 = new HTMLGraphic(component);
            hTMLGraphic2.setIgnoreMouse(true);
            hTMLGraphic2.setFont(VALUES_FONT);
            hTMLGraphic2.setColor(Color.BLACK);
            hTMLGraphic2.setHTML("<html>A<sub>" + (i + 1) + "</sub></html>");
            hTMLGraphic2.centerRegistrationPoint();
            hTMLGraphic2.setLocation(n2, 40);
            this.addGraphic(hTMLGraphic2);
            HTMLGraphic hTMLGraphic3 = new HTMLGraphic(component);
            hTMLGraphic3.setIgnoreMouse(true);
            hTMLGraphic3.setFont(VALUES_FONT);
            hTMLGraphic3.setColor(Color.BLACK);
            hTMLGraphic3.setHTML("-0.00");
            hTMLGraphic3.centerRegistrationPoint();
            hTMLGraphic3.setLocation(n2, 60);
            this.addGraphic(hTMLGraphic3);
            n2 += 37;
            this._valueGraphics.add(hTMLGraphic3);
        }
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, OQCResources.CLOSE_BUTTON_IMAGE);
        phetImageGraphic.setLocation(5, 5);
        this.addGraphic(phetImageGraphic);
        phetImageGraphic.addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CheatPanel.this.setVisible(false);
            }
        });
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    public void update() {
        if (this.isVisible()) {
            int n = this._outputFourierSeries.getNumberOfHarmonics();
            for (int i = 0; i < n; ++i) {
                double d = this._outputFourierSeries.getHarmonic(i).getAmplitude();
                String string = CHEAT_FORMAT.format(d);
                ((HTMLGraphic)this._valueGraphics.get(i)).setHTML(string);
            }
        }
    }
}

