/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.charts.FlattenedChart;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.model.Harmonic;
import edu.colorado.phet.opticalquantumcontrol.view.AmplitudeSlider;
import edu.colorado.phet.opticalquantumcontrol.view.AmplitudesChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public class AmplitudesView
extends GraphicLayerSet
implements SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(355, 265);
    private static final Color BACKGROUND_COLOR = new Color(195, 195, 195);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final Range2D CHART_RANGE = new Range2D(1.0, -1.0, 7.0, 1.0);
    private static final Dimension CHART_SIZE = new Dimension(275, 200);
    private FourierSeries _fourierSeries;
    private FlattenedChart _flattenedChart;
    private GraphicLayerSet _slidersGraphic;
    private ArrayList _sliders;
    private EventListenerList _listenerList;
    private int _previousNumberOfHarmonics;

    public AmplitudesView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new RoundRectangle2D.Double(0.0, 0.0, AmplitudesView.BACKGROUND_SIZE.width, AmplitudesView.BACKGROUND_SIZE.height, 20.0, 20.0));
        phetShapeGraphic.setPaint(BACKGROUND_COLOR);
        phetShapeGraphic.setStroke(BACKGROUND_STROKE);
        phetShapeGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        phetShapeGraphic.setLocation(0, 0);
        this.addGraphic(phetShapeGraphic, 1.0);
        String string = OQCResources.AMPLITUDES;
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        hTMLGraphic.setRegistrationPoint(hTMLGraphic.getWidth() / 2, 0);
        hTMLGraphic.rotate(-1.5707963267948966);
        hTMLGraphic.setLocation(10, AmplitudesView.BACKGROUND_SIZE.height / 2);
        this.addGraphic(hTMLGraphic, 2.0);
        AmplitudesChart amplitudesChart = new AmplitudesChart(component, CHART_RANGE, CHART_SIZE);
        amplitudesChart.setLocation(0, 0);
        amplitudesChart.setRegistrationPoint(0, 0);
        int n = 25;
        int n2 = 10;
        this._flattenedChart = new FlattenedChart(component, amplitudesChart, n, n2);
        this.addGraphic(this._flattenedChart, 3.0);
        this._flattenedChart.setRegistrationPoint(n, AmplitudesView.CHART_SIZE.height / 2);
        this._flattenedChart.setLocation(60, 50 + AmplitudesView.CHART_SIZE.height / 2 - n2);
        this._slidersGraphic = new GraphicLayerSet(component);
        this.addGraphic(this._slidersGraphic, 4.0);
        phetShapeGraphic.setIgnoreMouse(true);
        hTMLGraphic.setIgnoreMouse(true);
        this._flattenedChart.setIgnoreMouse(true);
        this._sliders = new ArrayList();
        this._listenerList = new EventListenerList();
        this.reset();
    }

    public void reset() {
        this._previousNumberOfHarmonics = 0;
        this.update();
    }

    public void update() {
        int n = this._fourierSeries.getNumberOfHarmonics();
        if (n != this._previousNumberOfHarmonics) {
            this._slidersGraphic.clear();
            int n2 = 80;
            int n3 = (AmplitudesView.CHART_SIZE.width - n2) / 7;
            double d = 400.0 / (double)(n - 1);
            for (int i = 0; i < n; ++i) {
                Harmonic harmonic = this._fourierSeries.getHarmonic(i);
                AmplitudeSlider amplitudeSlider = null;
                if (i < this._sliders.size()) {
                    amplitudeSlider = (AmplitudeSlider)this._sliders.get(i);
                    amplitudeSlider.setHarmonic(harmonic);
                } else {
                    amplitudeSlider = new AmplitudeSlider(this.getComponent(), harmonic);
                    this._sliders.add(amplitudeSlider);
                }
                this._slidersGraphic.addGraphic(amplitudeSlider);
                amplitudeSlider.setMaxSize(n3, AmplitudesView.CHART_SIZE.height);
                int n4 = this._flattenedChart.getLocation().x + (i + 1) * 10 + i * n3 + n3 / 2;
                int n5 = this._flattenedChart.getLocation().y + 10;
                amplitudeSlider.setLocation(n4, n5);
                this._previousNumberOfHarmonics = n;
            }
        }
    }
}

