/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.model.Harmonic;
import edu.colorado.phet.opticalquantumcontrol.view.HarmonicColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class AmplitudeSlider
extends GraphicLayerSet
implements SimpleObserver {
    private static final Font VALUE_FONT = new PhetFont(0, 12);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(0, 12);
    private static final Color KNOB_FILL_COLOR = Color.BLACK;
    private static final Dimension DEFAULT_TRACK_SIZE = new Dimension(40, 100);
    private static final Color DEFAULT_TRACK_COLOR = Color.WHITE;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final Color TRACK_BORDER_COLOR = Color.BLACK;
    private Harmonic _harmonic;
    private Dimension _maxSize;
    private HTMLGraphic _labelGraphic;
    private PhetGraphic _valueGraphic;
    private JTextField _valueTextField;
    private NumberFormat _valueFormatter;
    private PhetShapeGraphic _trackGraphic;
    private Rectangle _trackRectangle;
    private Color _trackColor;
    private PhetShapeGraphic _knobGraphic;
    private Rectangle _knobRectangle;
    private PhetShapeGraphic _clickZoneGraphic;
    private Rectangle _clickZoneRectangle;
    private Point _somePoint;

    public AmplitudeSlider(Component component, Harmonic harmonic) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        assert (harmonic != null);
        this._harmonic = harmonic;
        this._harmonic.addObserver(this);
        this._maxSize = new Dimension(DEFAULT_TRACK_SIZE);
        this._somePoint = new Point();
        Object object = String.valueOf(this._harmonic.getOrder() + 1);
        String string = "<html>A<sub>" + (String)object + "</sub></html>";
        this._labelGraphic = new HTMLGraphic(component, LABEL_FONT, string, LABEL_COLOR);
        this._labelGraphic.centerRegistrationPoint();
        this._labelGraphic.setLocation(0, 0);
        this._valueFormatter = new DecimalFormat("0.00");
        this._valueTextField = new JTextField(this._valueFormatter.format(0.0));
        this._valueTextField.setFont(VALUE_FONT);
        this._valueTextField.setColumns(3);
        this._valueGraphic = PhetJComponent.newInstance(component, this._valueTextField);
        this._valueGraphic.setName("AmplitudeSlider.value");
        this._valueGraphic.centerRegistrationPoint();
        this._valueGraphic.setLocation(0, 0);
        this._clickZoneGraphic = new PhetShapeGraphic(component);
        this._clickZoneRectangle = new Rectangle(1, 1, this._maxSize.width, this._maxSize.height);
        this._clickZoneGraphic.setShape(this._clickZoneRectangle);
        this._clickZoneGraphic.setName("AmplitudeSlider.clickZone");
        this._clickZoneGraphic.setPaint(new Color(0, 0, 0, 0));
        this._clickZoneGraphic.centerRegistrationPoint();
        this._clickZoneGraphic.setLocation(0, 0);
        this._trackRectangle = new Rectangle();
        this._trackColor = DEFAULT_TRACK_COLOR;
        this._trackGraphic = new PhetShapeGraphic(component);
        this._trackGraphic.setName("AmplitudeSlider.track");
        this._trackGraphic.setShape(this._trackRectangle);
        this._trackGraphic.setPaint(this._trackColor);
        this._trackGraphic.setBorderColor(TRACK_BORDER_COLOR);
        this._trackGraphic.setStroke(TRACK_STROKE);
        this._trackGraphic.setLocation(0, 0);
        this._knobRectangle = new Rectangle(1, 0, this._maxSize.width + 1, 4);
        this._knobGraphic = new PhetShapeGraphic(component);
        this._knobGraphic.setName("AmplitudeSlider.knob");
        this._knobGraphic.setShape(this._knobRectangle);
        this._knobGraphic.setPaint(KNOB_FILL_COLOR);
        this._knobGraphic.centerRegistrationPoint();
        this._knobGraphic.setLocation(0, 0);
        this._labelGraphic.setIgnoreMouse(true);
        object = new TextFieldEventListener();
        this._valueTextField.addActionListener((ActionListener)object);
        this._valueTextField.addFocusListener((FocusListener)object);
        this._valueTextField.addKeyListener((KeyListener)object);
        this._clickZoneGraphic.setCursorHand();
        this._clickZoneGraphic.addMouseInputListener(new ClickZoneEventListener());
        this._knobGraphic.setCursorHand();
        this._knobGraphic.addMouseInputListener(new KnobEventListener());
        this._trackGraphic.setCursorHand();
        this._trackGraphic.addMouseInputListener(new TrackEventListener());
        this.addGraphic(this._labelGraphic, 5.0);
        this.addGraphic(this._valueGraphic, 4.0);
        this.addGraphic(this._clickZoneGraphic, 1.0);
        this.addGraphic(this._trackGraphic, 2.0);
        this.addGraphic(this._knobGraphic, 3.0);
        this.update();
    }

    public void setHarmonic(Harmonic harmonic) {
        assert (harmonic != null);
        if (this._harmonic != null) {
            this._harmonic.removeObserver(this);
        }
        this._harmonic = harmonic;
        this._harmonic.addObserver(this);
        this.update();
    }

    public void setMaxSize(int n, int n2) {
        this._maxSize.setSize(n, n2);
        this._clickZoneRectangle.setRect(0.0, 0.0, this._maxSize.width, this._maxSize.height);
        this._clickZoneGraphic.setShapeDirty();
        this._clickZoneGraphic.centerRegistrationPoint();
        this._knobRectangle.setRect(1.0, 0.0, this._maxSize.width + 1, 4.0);
        this._knobGraphic.setShapeDirty();
        this._knobGraphic.centerRegistrationPoint();
        this.update();
    }

    private boolean processUserInput() {
        Serializable serializable;
        boolean bl = true;
        String string = this._valueTextField.getText();
        double d = 0.0;
        try {
            serializable = new Double(string);
            d = serializable;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.showUserInputErrorDialog();
            this.update();
        }
        if (Math.abs(d) > 1.0) {
            bl = false;
            this.showUserInputErrorDialog();
            this.update();
        } else if (d != this._harmonic.getAmplitude()) {
            serializable = HarmonicColors.getInstance().getColor(this._harmonic);
            this.updateSlider(d, (Color)serializable);
            this._harmonic.setAmplitude(d);
        }
        return bl;
    }

    private void showUserInputErrorDialog() {
        String string = OQCResources.AMPLITUDE_ERROR_MESSAGE;
        JOptionPane jOptionPane = new JOptionPane(string, 0, -1);
        jOptionPane.createDialog(this.getComponent(), null).setVisible(true);
    }

    public void update() {
        double d = this._harmonic.getAmplitude();
        if (d == 0.0) {
            d = 0.0;
        }
        Color color = HarmonicColors.getInstance().getColor(this._harmonic);
        this.updateSlider(d, color);
    }

    private void updateSlider(double d, Color color) {
        this._labelGraphic.setLocation(0, -(this._maxSize.height / 2 + 35));
        this._valueTextField.setText(this._valueFormatter.format(d));
        this._valueGraphic.setLocation(0, -(this._maxSize.height / 2 + 17));
        int n = this._maxSize.width;
        int n2 = (int)Math.abs((double)(this._maxSize.height / 2) * (d / 1.0));
        int n3 = -(n / 2);
        int n4 = d > 0.0 ? -n2 : 0;
        this._trackRectangle.setBounds(n3, n4, n, n2);
        this._trackGraphic.setShapeDirty();
        this._trackGraphic.setPaint(color);
        int n5 = this._knobGraphic.getX();
        int n6 = (int)(-((double)(this._maxSize.height / 2) * (d / 1.0)));
        this._knobGraphic.setLocation(n5, n6);
        this.repaint();
    }

    private void setAmplitude(Point point) {
        double d = 0.0;
        try {
            AffineTransform affineTransform = this.getNetTransform();
            affineTransform.inverseTransform(point, this._somePoint);
            d = this._somePoint.getY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        d = -d;
        double d2 = 1.0 * (d / ((double)this._maxSize.height / 2.0));
        d2 = MathUtil.clamp(-1.0, d2, 1.0);
        this._harmonic.setAmplitude(d2);
    }

    private class ClickZoneEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }
    }

    private class KnobEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }
    }

    private class TextFieldEventListener
    extends GraphicLayerSet.KeyAdapter
    implements ActionListener,
    FocusListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AmplitudeSlider.this._valueTextField) {
                AmplitudeSlider.this.processUserInput();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            AmplitudeSlider.this._valueTextField.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
            boolean bl;
            if (!focusEvent.isTemporary() && !(bl = AmplitudeSlider.this.processUserInput())) {
                AmplitudeSlider.this._valueTextField.requestFocus();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            double d;
            if (keyEvent.getKeyCode() == 38) {
                double d2 = AmplitudeSlider.this._harmonic.getAmplitude() + 0.01;
                if (d2 <= 1.0) {
                    AmplitudeSlider.this._harmonic.setAmplitude(d2);
                }
            } else if (keyEvent.getKeyCode() == 40 && (d = AmplitudeSlider.this._harmonic.getAmplitude() - 0.01) >= -1.0) {
                AmplitudeSlider.this._harmonic.setAmplitude(d);
            }
        }
    }

    private class TrackEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }
    }
}

