/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.module;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.opticalquantumcontrol.OQCConstants;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.enums.MoleculeEnum;
import edu.colorado.phet.opticalquantumcontrol.help.HelpBubble;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.module.AbstractModule;
import edu.colorado.phet.opticalquantumcontrol.view.AmplitudesView;
import edu.colorado.phet.opticalquantumcontrol.view.CheatPanel;
import edu.colorado.phet.opticalquantumcontrol.view.DiffractionGrating;
import edu.colorado.phet.opticalquantumcontrol.view.InputPulseView;
import edu.colorado.phet.opticalquantumcontrol.view.LightRays;
import edu.colorado.phet.opticalquantumcontrol.view.Mirror;
import edu.colorado.phet.opticalquantumcontrol.view.MoleculeAnimation;
import edu.colorado.phet.opticalquantumcontrol.view.OutputPulseView;
import java.awt.Color;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public class OQCModule
extends AbstractModule
implements ActionListener {
    private static final Color APPARATUS_BACKGROUND = Color.BLACK;
    private FourierSeries _inputFourierSeries;
    private FourierSeries _userFourierSeries;
    private FourierSeries _outputFourierSeries;
    private AmplitudesView _amplitudesView;
    private InputPulseView _inputPulseView;
    private OutputPulseView _outputPulseView;
    private MoleculeAnimation _animation;
    private JButton _newButton;
    private CheatPanel _cheatPanel;
    private int _moleculeIndex;

    public OQCModule() {
        super(OQCResources.MODULE_TITLE, new SwingClock(40, 1.0));
        this.setLogoPanel(null);
        this.setHelpPanel(null);
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._inputFourierSeries = new FourierSeries(7, 440.0);
        for (int i = 0; i < this._inputFourierSeries.getNumberOfHarmonics(); ++i) {
            this._inputFourierSeries.getHarmonic(i).setAmplitude(1.0);
        }
        this._userFourierSeries = new FourierSeries(7, 440.0);
        this._outputFourierSeries = new FourierSeries(7, 440.0);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 1008, 699);
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        this._inputPulseView = new InputPulseView(apparatusPanel3, this._inputFourierSeries);
        apparatusPanel3.addGraphic(this._inputPulseView);
        this._inputPulseView.setLocation(470, 15);
        this._outputPulseView = new OutputPulseView(apparatusPanel3, this._userFourierSeries, this._outputFourierSeries);
        apparatusPanel3.addGraphic(this._outputPulseView);
        this._outputPulseView.setLocation(470, 490);
        this._newButton = new JButton(OQCResources.NEW_OUTPUT_PULSE);
        this._newButton.setOpaque(false);
        this._newButton.addActionListener(this);
        PhetGraphic phetGraphic = PhetJComponent.newInstance(apparatusPanel3, this._newButton);
        phetGraphic.setRegistrationPoint(phetGraphic.getWidth(), 0);
        phetGraphic.setLocation(1000, 493);
        apparatusPanel3.addGraphic(phetGraphic);
        phetGraphic = new LightRays(apparatusPanel3, this._userFourierSeries);
        apparatusPanel3.addGraphic(phetGraphic);
        phetGraphic.setLocation(86, 25);
        Object object = new Mirror(apparatusPanel3);
        apparatusPanel3.addGraphic((PhetGraphic)object);
        ((PhetGraphic)object).centerRegistrationPoint();
        ((PhetGraphic)object).rotate(Math.toRadians(180.0));
        ((PhetGraphic)object).setLocation(210, 40);
        Object object2 = new HTMLGraphic(apparatusPanel3);
        ((PhetGraphic)object2).setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)object2).setFont(new PhetFont(0, 18));
        ((HTMLGraphic)object2).setColor(Color.BLACK);
        ((HTMLGraphic)object2).setHTML(OQCResources.MIRROR);
        ((PhetGraphic)object2).setLocation(55, 15);
        ((PhetGraphic)object2).setIgnoreMouse(true);
        apparatusPanel3.addGraphic((PhetGraphic)object2);
        object = new Mirror(apparatusPanel3);
        apparatusPanel3.addGraphic((PhetGraphic)object);
        ((PhetGraphic)object).setLocation(50, 630);
        object2 = new HTMLGraphic(apparatusPanel3);
        ((PhetGraphic)object2).setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)object2).setFont(new PhetFont(0, 18));
        ((HTMLGraphic)object2).setColor(Color.BLACK);
        ((HTMLGraphic)object2).setHTML(OQCResources.MIRROR);
        ((PhetGraphic)object2).setLocation(55, 655);
        ((PhetGraphic)object2).setIgnoreMouse(true);
        apparatusPanel3.addGraphic((PhetGraphic)object2);
        object = new DiffractionGrating(apparatusPanel3);
        apparatusPanel3.addGraphic((PhetGraphic)object);
        ((PhetGraphic)object).centerRegistrationPoint();
        ((PhetGraphic)object).rotate(Math.toRadians(-15.0));
        ((PhetGraphic)object).setLocation(440, 250);
        object2 = new DiffractionGrating(apparatusPanel3);
        apparatusPanel3.addGraphic((PhetGraphic)object2);
        ((PhetGraphic)object2).centerRegistrationPoint();
        ((PhetGraphic)object2).rotate(Math.toRadians(195.0));
        ((PhetGraphic)object2).setLocation(440, 445);
        PhetGraphic phetGraphic2 = new HTMLGraphic(apparatusPanel3);
        phetGraphic2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)phetGraphic2).setFont(new PhetFont(0, 18));
        ((HTMLGraphic)phetGraphic2).setColor(Color.LIGHT_GRAY);
        ((HTMLGraphic)phetGraphic2).setHTML(OQCResources.DIFFRACTION_GRATING);
        phetGraphic2.setLocation(400, 325);
        phetGraphic2.setIgnoreMouse(true);
        apparatusPanel3.addGraphic(phetGraphic2);
        Object object3 = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(-10.0, -40.0), 10.0, 10.0, 4.0);
        PhetGraphic phetGraphic3 = new PhetShapeGraphic(apparatusPanel3);
        ((PhetShapeGraphic)phetGraphic3).setShape(((Arrow)object3).getShape());
        ((PhetShapeGraphic)phetGraphic3).setColor(Color.LIGHT_GRAY);
        phetGraphic3.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        phetGraphic3.setLocation(440, 315);
        phetGraphic3.setIgnoreMouse(true);
        apparatusPanel3.addGraphic(phetGraphic3);
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(-10.0, 40.0), 10.0, 10.0, 4.0);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(apparatusPanel3);
        phetShapeGraphic.setShape(arrow.getShape());
        phetShapeGraphic.setColor(Color.LIGHT_GRAY);
        phetShapeGraphic.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        phetShapeGraphic.setIgnoreMouse(true);
        phetShapeGraphic.setLocation(440, 380);
        apparatusPanel3.addGraphic(phetShapeGraphic);
        this._amplitudesView = new AmplitudesView(apparatusPanel3, this._userFourierSeries);
        apparatusPanel3.addGraphic(this._amplitudesView);
        this._amplitudesView.setLocation(15, 215);
        object = new JButton(OQCResources.RESET);
        ((JComponent)object).setOpaque(false);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OQCModule.this.setWaitCursorEnabled(true);
                OQCModule.this.resetAmplitudes();
                OQCModule.this.setWaitCursorEnabled(false);
            }
        });
        object2 = PhetJComponent.newInstance(apparatusPanel3, (JComponent)object);
        ((PhetGraphic)object2).setLocation(this._amplitudesView.getX() + 5, this._amplitudesView.getY() + 5);
        ((PhetGraphic)object2).scale(0.7);
        apparatusPanel3.addGraphic((PhetGraphic)object2);
        object = new HTMLGraphic(apparatusPanel3);
        ((PhetGraphic)object).setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)object).setFont(new PhetFont(0, 18));
        ((HTMLGraphic)object).setColor(Color.LIGHT_GRAY);
        ((HTMLGraphic)object).setHTML(OQCResources.MASK);
        ((PhetGraphic)object).setLocation(10, 535);
        ((PhetGraphic)object).setIgnoreMouse(true);
        apparatusPanel3.addGraphic((PhetGraphic)object);
        object2 = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(10.0, -40.0), 10.0, 10.0, 4.0);
        phetGraphic2 = new PhetShapeGraphic(apparatusPanel3);
        ((PhetShapeGraphic)phetGraphic2).setShape(((Arrow)object2).getShape());
        ((PhetShapeGraphic)phetGraphic2).setColor(Color.LIGHT_GRAY);
        phetGraphic2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        phetGraphic2.setLocation(30, 530);
        phetGraphic2.setIgnoreMouse(true);
        apparatusPanel3.addGraphic(phetGraphic2);
        this._cheatPanel = new CheatPanel(apparatusPanel3, this._outputFourierSeries);
        apparatusPanel3.addGraphic(this._cheatPanel);
        this._cheatPanel.setLocation(68, 130);
        this._cheatPanel.setVisible(false);
        this._animation = new MoleculeAnimation(apparatusPanel3, this, this._userFourierSeries, this._outputFourierSeries);
        apparatusPanel3.addGraphic(this._animation);
        this._animation.setLocation(515, 222);
        baseModel.addModelElement(this._animation);
        this.getClockControlPanel().setVisible(false);
        object = new HTMLGraphic(apparatusPanel3);
        ((PhetGraphic)object).setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        ((HTMLGraphic)object).setHTML(OQCResources.INSTRUCTIONS);
        ((HTMLGraphic)object).setFont(new PhetFont(0, 18));
        ((HTMLGraphic)object).setColor(OQCConstants.OUTPUT_PULSE_COLOR);
        ((PhetGraphic)object).setRegistrationPoint(0, ((PhetGraphic)object).getHeight() / 2);
        ((PhetGraphic)object).setLocation(790, 350);
        ((PhetGraphic)object).setIgnoreMouse(true);
        apparatusPanel3.addGraphic((PhetGraphic)object);
        object2 = new HelpBubble(apparatusPanel3, OQCResources.HELP_AMPLITUDE_SLIDERS);
        ((HelpBubble)object2).pointAt(new Point(125, 445), 0, 45);
        this.addHelpItem((PhetGraphic)object2);
        phetGraphic2 = new HelpBubble(apparatusPanel3, OQCResources.HELP_AMPLITUDE_TEXTFIELDS);
        ((HelpBubble)phetGraphic2).pointAt(new Point(146, 238), 3, 30);
        this.addHelpItem(phetGraphic2);
        object3 = new HelpBubble(apparatusPanel3, OQCResources.HELP_AMPLITUDE_RESET);
        ((HelpBubble)object3).pointAt(new Point(47, 221), 3, 80);
        this.addHelpItem((PhetGraphic)object3);
        phetGraphic3 = new HelpBubble(apparatusPanel3, OQCResources.HELP_NEW_PULSE);
        ((HelpBubble)phetGraphic3).pointAt(new Point(970, 495), 5, 30);
        this.addHelpItem(phetGraphic3);
        this.reset();
    }

    public void reset() {
        Random random = new Random();
        this._moleculeIndex = random.nextInt(MoleculeEnum.size());
        this.newGame();
    }

    public void setCheatEnabled(boolean bl) {
        this._cheatPanel.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._newButton) {
            this.newGame();
        }
    }

    public void newGame() {
        this.setWaitCursorEnabled(true);
        this._userFourierSeries.setAdjusting(true);
        this._outputFourierSeries.setAdjusting(true);
        this.resetAmplitudes();
        ++this._moleculeIndex;
        if (this._moleculeIndex >= MoleculeEnum.size()) {
            this._moleculeIndex = 0;
        }
        MoleculeEnum moleculeEnum = MoleculeEnum.getByIndex(this._moleculeIndex);
        double[] dArray = MoleculeEnum.getAmplitudes(moleculeEnum);
        for (int i = 0; i < this._outputFourierSeries.getNumberOfHarmonics(); ++i) {
            this._outputFourierSeries.getHarmonic(i).setAmplitude(dArray[i]);
        }
        this._animation.setMolecule(this._moleculeIndex);
        this._animation.reset();
        this._cheatPanel.setVisible(false);
        this._userFourierSeries.setAdjusting(false);
        this._outputFourierSeries.setAdjusting(false);
        this.setWaitCursorEnabled(false);
    }

    private void resetAmplitudes() {
        for (int i = 0; i < this._userFourierSeries.getNumberOfHarmonics(); ++i) {
            double d = this._inputFourierSeries.getHarmonic(i).getAmplitude();
            this._userFourierSeries.getHarmonic(i).setAmplitude(d);
        }
    }
}

