/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.opticalquantumcontrol.OQCConstants;
import edu.colorado.phet.opticalquantumcontrol.model.FourierSeries;
import edu.colorado.phet.opticalquantumcontrol.model.Harmonic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class FourierSumPlot
extends LinePlot {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private FourierSeries _fourierSeries;
    private double _period;
    private double _startX;
    private double _pixelsPerPoint;
    private double _maxAmplitude;
    private Point2D[] _points;
    private boolean _useCosines;
    private double _yScale;

    public FourierSumPlot(Component component, Chart chart, FourierSeries fourierSeries) {
        super(component, chart);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._period = 1.0;
        this._startX = 0.0;
        this._pixelsPerPoint = 1.0;
        this._maxAmplitude = 1.0;
        this._points = null;
        this._useCosines = false;
        this._yScale = 1.0;
        this.setDataSet(new DataSet());
        this.setBorderColor(DEFAULT_COLOR);
        this.setStroke(DEFAULT_STROKE);
        this.updateDataSet();
    }

    public void setPeriod(double d) {
        assert (d >= 0.0);
        if (d < 0.0) {
            throw new IllegalArgumentException("period must be >= 0");
        }
        if (d != this._period) {
            this._period = d;
            this.updateDataSet();
        }
    }

    public void setPixelsPerPoint(double d) {
        assert (d > 0.0);
        if (d != this._pixelsPerPoint) {
            this._pixelsPerPoint = d;
            this.updateDataSet();
        }
    }

    public double getMaxAmplitude() {
        return this._maxAmplitude;
    }

    public void setUseCosines(boolean bl) {
        this._useCosines = bl;
        this.updateDataSet();
    }

    public void setYScale(double d) {
        this._yScale = d;
        this.updateDataSet();
    }

    public void updateDataSet() {
        Chart chart = this.getChart();
        Range2D range2D = chart.getRange();
        DataSet dataSet = this.getDataSet();
        int n = this._fourierSeries.getNumberOfHarmonics();
        this._maxAmplitude = 0.0;
        dataSet.clear();
        double d = this.modelToViewX(range2D.getMinX());
        double d2 = this.modelToViewX(range2D.getMaxX());
        double d3 = d2 - d + 1.0;
        int n2 = (int)(d3 / this._pixelsPerPoint);
        double d4 = Math.abs(range2D.getMaxX() - range2D.getMinX());
        double d5 = d4 / (double)n2;
        double d6 = this.modelToViewX(this._startX);
        if (this._points == null || n2 + 1 != this._points.length) {
            this._points = new Point2D.Double[n2 + 1];
        }
        for (int i = 0; i < n; ++i) {
            Harmonic harmonic = this._fourierSeries.getHarmonic(i);
            double d7 = harmonic.getAmplitude();
            double d8 = d4 / this._period * (double)(harmonic.getOrder() + 1);
            double d9 = d8 * (Math.PI * 2) / (double)n2;
            double d10 = Math.abs((d6 - d) / this._pixelsPerPoint) * d9;
            if (d6 > d) {
                d10 = -d10;
            }
            for (int j = 0; j < this._points.length; ++j) {
                double d11;
                if (i == 0) {
                    d11 = range2D.getMinX() + (double)j * d5;
                    if (this._points[j] == null) {
                        this._points[j] = new Point2D.Double(d11, 0.0);
                    } else {
                        this._points[j].setLocation(d11, 0.0);
                    }
                }
                if (d7 != 0.0) {
                    d11 = d10 + (double)j * d9;
                    double d12 = this._useCosines ? OQCConstants.TRIG_CACHE.cos(d11) : OQCConstants.TRIG_CACHE.sin(d11);
                    double d13 = this._points[j].getX();
                    double d14 = this._points[j].getY() + this._yScale * d7 * d12;
                    this._points[j].setLocation(d13, d14);
                }
                if (i != n - 1 || !((d11 = Math.abs(this._points[j].getY())) > this._maxAmplitude)) continue;
                this._maxAmplitude = d11;
            }
        }
        dataSet.addAllPoints(this._points);
    }

    private double modelToViewX(double d) {
        return this.getChart().transformXDouble(d);
    }

    public void transformChanged() {
        this.updateDataSet();
        super.transformChanged();
    }
}

