/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class FlattenedChart
extends PhetImageGraphic {
    private Chart _chart;
    private int _xOffset;
    private int _yOffset;

    public FlattenedChart(Component component, Chart chart, int n, int n2) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        assert (chart != null);
        this._chart = chart;
        this._chart.setLocation(0, 0);
        this._chart.setRegistrationPoint(0, 0);
        this._chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                FlattenedChart.this.flatten();
            }
        });
        this._xOffset = n;
        this._yOffset = n2;
        this.flatten();
    }

    public void flatten() {
        this._chart.setBoundsDirty();
        int n = this._chart.getWidth() + this._xOffset;
        int n2 = this._chart.getHeight() + this._yOffset;
        if (n > 0 && n2 > 0) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            RenderingHints renderingHints = this.getRenderingHints();
            if (renderingHints != null) {
                graphics2D.setRenderingHints(this.getRenderingHints());
            }
            graphics2D.translate(this._xOffset, this._yOffset);
            this._chart.paint(graphics2D);
            this.setImage(bufferedImage);
        } else {
            this.setImage(null);
        }
    }
}

