/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticalquantumcontrol;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.opticalquantumcontrol.OQCConstants;
import edu.colorado.phet.opticalquantumcontrol.OQCResources;
import edu.colorado.phet.opticalquantumcontrol.help.ExplanationDialog;
import edu.colorado.phet.opticalquantumcontrol.module.OQCModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JMenuItem;

public class OpticalQuantumControlApplication
extends PhetApplication {
    private OQCModule _shaperModule;
    private JDialog _explanationDialog;

    public OpticalQuantumControlApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        this._shaperModule = new OQCModule();
        this.addModule(this._shaperModule);
    }

    private void initMenubar() {
        HelpMenu helpMenu = this.getPhetFrame().getHelpMenu();
        if (helpMenu != null) {
            JMenuItem jMenuItem = new JMenuItem(OQCResources.MENU_EXPLANATION);
            jMenuItem.setMnemonic(OQCResources.MENU_EXPLANATION_MNEMONIC);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpticalQuantumControlApplication.this._explanationDialog = new ExplanationDialog(OpticalQuantumControlApplication.this.getPhetFrame());
                    OpticalQuantumControlApplication.this._explanationDialog.setVisible(true);
                }
            });
            helpMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem(OQCResources.MENU_CHEAT);
            jMenuItem2.setMnemonic(OQCResources.MENU_CHEAT_MNEMONIC);
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OpticalQuantumControlApplication.this._shaperModule.setCheatEnabled(true);
                }
            });
            helpMenu.add(jMenuItem2);
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new OpticalQuantumControlApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "optical-quantum-control");
        phetApplicationConfig.setFrameSetup(OQCConstants.FRAME_SETUP);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

