/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.nuclearreactor;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModel;
import edu.colorado.phet.nuclearphysics.util.SimpleChartPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class NuclearReactorEnergyGraphPanel
extends JPanel {
    private static final String TOTAL_ENERGY_ROW_KEY = new String("Total");
    private static final String TOTAL_ENERGY_COLUMN_KEY = NuclearPhysicsStrings.ENERGY_GRAPH_LABEL;
    private static final String PER_SECOND_ENERGY_ROW_KEY = new String("Instantaneous");
    private static final String PER_SECOND_ENERGY_COLUMN_KEY = NuclearPhysicsStrings.POWER_GRAPH_LABEL;
    private static final Font LABEL_FONT = new PhetFont(1, 14);
    private static final Font TITLE_FONT = new PhetFont(1, 16);
    private NuclearReactorModel _nuclearReactorModel;
    private DefaultCategoryDataset _energyPerSecondDataSet;
    private DefaultCategoryDataset _totalEnergyDataSet;
    private JFreeChart _energyPerSecondChart;
    private JFreeChart _totalEnergyChart;

    public NuclearReactorEnergyGraphPanel(NuclearReactorModel nuclearReactorModel) {
        this._nuclearReactorModel = nuclearReactorModel;
        this._energyPerSecondDataSet = new DefaultCategoryDataset();
        this._totalEnergyDataSet = new DefaultCategoryDataset();
        this._nuclearReactorModel.addListener(new NuclearReactorModel.Adapter(){

            public void energyChanged() {
                NuclearReactorEnergyGraphPanel.this.updateLevels();
            }
        });
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.ENERGY_GRAPHS_TITLE, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridLayout(0, 2));
        this._energyPerSecondChart = this.createEnergyPerSecondChart();
        SimpleChartPanel simpleChartPanel = new SimpleChartPanel(this._energyPerSecondChart, 100, 300);
        this.add(simpleChartPanel);
        this._totalEnergyChart = this.createTotalEnergyChart();
        SimpleChartPanel simpleChartPanel2 = new SimpleChartPanel(this._totalEnergyChart, 100, 300);
        this.add(simpleChartPanel2);
        this.updateLevels();
    }

    private void updateLevels() {
        this._totalEnergyDataSet.setValue(this._nuclearReactorModel.getTotalEnergyReleased(), (Comparable)((Object)TOTAL_ENERGY_ROW_KEY), (Comparable)((Object)TOTAL_ENERGY_COLUMN_KEY));
        this._energyPerSecondDataSet.setValue(this._nuclearReactorModel.getEnergyReleasedPerSecond(), (Comparable)((Object)PER_SECOND_ENERGY_ROW_KEY), (Comparable)((Object)PER_SECOND_ENERGY_COLUMN_KEY));
    }

    private JFreeChart createEnergyPerSecondChart() {
        this._energyPerSecondDataSet.setValue(2.5E-9, (Comparable)((Object)PER_SECOND_ENERGY_ROW_KEY), (Comparable)((Object)PER_SECOND_ENERGY_COLUMN_KEY));
        JFreeChart jFreeChart = ChartFactory.createBarChart(null, null, NuclearPhysicsStrings.POWER_GRAPH_UNITS, this._energyPerSecondDataSet, PlotOrientation.VERTICAL, false, false, false);
        jFreeChart.setBackgroundPaint(NuclearPhysicsConstants.NUCLEAR_FISSION_CONTROL_PANEL_COLOR);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.darkGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        TextTitle textTitle = new TextTitle(NuclearPhysicsStrings.POWER_GRAPH_LABEL);
        textTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textTitle.setFont(TITLE_FONT);
        textTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.setTitle(textTitle);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setRange(0.0, 2.5E-9);
        valueAxis.setTickLabelsVisible(false);
        valueAxis.setLabelFont(LABEL_FONT);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setTickLabelsVisible(false);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        barRenderer.setItemMargin(0.01);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.orange, 0.0f, 0.0f, Color.lightGray);
        barRenderer.setSeriesPaint(0, gradientPaint);
        return jFreeChart;
    }

    private JFreeChart createTotalEnergyChart() {
        this._totalEnergyDataSet.setValue(1.1E-8, (Comparable)((Object)TOTAL_ENERGY_ROW_KEY), (Comparable)((Object)TOTAL_ENERGY_COLUMN_KEY));
        JFreeChart jFreeChart = ChartFactory.createBarChart(NuclearPhysicsStrings.ENERGY_GRAPH_LABEL, null, NuclearPhysicsStrings.ENERGY_GRAPH_UNITS, this._totalEnergyDataSet, PlotOrientation.VERTICAL, false, false, false);
        jFreeChart.setBackgroundPaint(NuclearPhysicsConstants.NUCLEAR_FISSION_CONTROL_PANEL_COLOR);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.DARK_GRAY);
        categoryPlot.setRangeGridlinePaint(Color.white);
        TextTitle textTitle = new TextTitle(NuclearPhysicsStrings.ENERGY_GRAPH_LABEL);
        textTitle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        textTitle.setFont(TITLE_FONT);
        textTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.setTitle(textTitle);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setRange(0.0, 1.1E-8);
        valueAxis.setTickLabelsVisible(false);
        valueAxis.setLabelFont(LABEL_FONT);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setTickLabelsVisible(false);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        barRenderer.setItemMargin(0.01);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        barRenderer.setSeriesPaint(0, gradientPaint);
        return jFreeChart;
    }
}

