/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class BetaDecayNucleusSelectionPanel
extends JPanel {
    private NucleusTypeControl _betaDecayModel;
    private JRadioButton _hydrogenRadioButton;
    private JRadioButton _carbonRadioButton;
    private JRadioButton _customNucleusRadioButton;

    public BetaDecayNucleusSelectionPanel(NucleusTypeControl nucleusTypeControl) {
        this._betaDecayModel = nucleusTypeControl;
        nucleusTypeControl.addListener(new NuclearDecayListenerAdapter(){

            public void nucleusTypeChanged() {
                BetaDecayNucleusSelectionPanel.this.updateButtonState();
            }
        });
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.NUCLEUS_SELECTION_BORDER_LABEL, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._hydrogenRadioButton = new JRadioButton();
        this._carbonRadioButton = new JRadioButton();
        this._customNucleusRadioButton = new JRadioButton();
        this._hydrogenRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BetaDecayNucleusSelectionPanel.this._betaDecayModel.setNucleusType(NucleusType.HYDROGEN_3);
            }
        });
        this._carbonRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BetaDecayNucleusSelectionPanel.this._betaDecayModel.setNucleusType(NucleusType.CARBON_14);
            }
        });
        this._customNucleusRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BetaDecayNucleusSelectionPanel.this._betaDecayModel.setNucleusType(NucleusType.LIGHT_CUSTOM);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._hydrogenRadioButton);
        buttonGroup.add(this._carbonRadioButton);
        buttonGroup.add(this._customNucleusRadioButton);
        this._hydrogenRadioButton.setSelected(true);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 25;
        this.add((Component)this._hydrogenRadioButton, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        LabeledNucleusImageNode labeledNucleusImageNode = new LabeledNucleusImageNode(NucleusType.HYDROGEN_3);
        labeledNucleusImageNode.scale(0.75);
        Image image = labeledNucleusImageNode.toImage();
        ImageIcon imageIcon = new ImageIcon(image);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(imageIcon);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._hydrogenRadioButton.doClick();
            }
        });
        NucleusDisplayInfo nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.HYDROGEN_3);
        JLabel jLabel2 = new JLabel(nucleusDisplayInfo.getName(), 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 25;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode2 = new LabeledNucleusImageNode(NucleusType.HELIUM_3);
        labeledNucleusImageNode2.scale(0.75);
        Image image2 = labeledNucleusImageNode2.toImage();
        ImageIcon imageIcon2 = new ImageIcon(image2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        JLabel jLabel3 = new JLabel(imageIcon2);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._hydrogenRadioButton.doClick();
            }
        });
        nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.HELIUM_3);
        JLabel jLabel4 = new JLabel(nucleusDisplayInfo.getName());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.createVerticalSpacingPanel(20), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 25;
        this.add((Component)this._carbonRadioButton, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        LabeledNucleusImageNode labeledNucleusImageNode3 = new LabeledNucleusImageNode(NucleusType.CARBON_14);
        Image image3 = labeledNucleusImageNode3.toImage();
        ImageIcon imageIcon3 = new ImageIcon(image3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        JLabel jLabel5 = new JLabel(imageIcon3);
        this.add((Component)jLabel5, gridBagConstraints);
        jLabel5.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._carbonRadioButton.doClick();
            }
        });
        nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.CARBON_14);
        JLabel jLabel6 = new JLabel(nucleusDisplayInfo.getName());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode4 = new LabeledNucleusImageNode(NucleusType.NITROGEN_14);
        Image image4 = labeledNucleusImageNode4.toImage();
        ImageIcon imageIcon4 = new ImageIcon(image4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        JLabel jLabel7 = new JLabel(imageIcon4);
        this.add((Component)jLabel7, gridBagConstraints);
        jLabel7.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._carbonRadioButton.doClick();
            }
        });
        nucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.NITROGEN_14);
        JLabel jLabel8 = new JLabel(nucleusDisplayInfo.getName());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.createVerticalSpacingPanel(20), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add((Component)this._customNucleusRadioButton, gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode5 = new LabeledNucleusImageNode(NucleusType.LIGHT_CUSTOM);
        Image image5 = labeledNucleusImageNode5.toImage();
        ImageIcon imageIcon5 = new ImageIcon(image5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        JLabel jLabel9 = new JLabel(imageIcon5);
        this.add((Component)jLabel9, gridBagConstraints);
        jLabel9.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._customNucleusRadioButton.doClick();
            }
        });
        JLabel jLabel10 = new JLabel(NuclearPhysicsStrings.CUSTOM_NUCLEUS_LEGEND_LABEL);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode6 = new LabeledNucleusImageNode(NucleusType.LIGHT_CUSTOM_POST_DECAY);
        Image image6 = labeledNucleusImageNode6.toImage();
        ImageIcon imageIcon6 = new ImageIcon(image6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        JLabel jLabel11 = new JLabel(imageIcon6);
        this.add((Component)jLabel11, gridBagConstraints);
        jLabel11.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BetaDecayNucleusSelectionPanel.this._customNucleusRadioButton.doClick();
            }
        });
        JLabel jLabel12 = new JLabel(NuclearPhysicsStrings.DECAYED_CUSTOM_NUCLEUS_LEGEND_LABEL);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        this.add((Component)jLabel12, gridBagConstraints);
    }

    public void updateButtonState() {
        if (this._betaDecayModel.getNucleusType() == NucleusType.HYDROGEN_3) {
            this._hydrogenRadioButton.setSelected(true);
        } else if (this._betaDecayModel.getNucleusType() == NucleusType.CARBON_14) {
            this._carbonRadioButton.setSelected(true);
        } else if (this._betaDecayModel.getNucleusType() == NucleusType.LIGHT_CUSTOM) {
            this._customNucleusRadioButton.setSelected(true);
        } else {
            System.err.println("Error: Unrecognized nucleus type.");
        }
    }

    private ImageIcon createArrowIcon(Color color) {
        ArrowNode arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 15.0), 8.0, 14.0, 6.0);
        arrowNode.setPaint(color);
        Image image = arrowNode.toImage();
        return new ImageIcon(image);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }
}

