/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import java.awt.geom.Point2D;
import java.util.Random;

public class AlphaParticle
extends SubatomicParticle {
    private static Random RAND = new Random();
    private int _tunnelingState = 0;

    public AlphaParticle(double d, double d2) {
        super(d, d2, 0.75 * (RAND.nextDouble() * 2.0 - 1.0), 0.75 * (RAND.nextDouble() * 2.0 - 1.0));
    }

    public void tunnel(Point2D point2D, double d, double d2, double d3) {
        double d4;
        double d5 = d2;
        if (RAND.nextDouble() > 0.98) {
            d5 = d3;
        }
        if ((d4 = RAND.nextDouble()) > 0.8) {
            d4 = RAND.nextDouble() * RAND.nextDouble();
        }
        double d6 = d + d4 * (d5 - d);
        double d7 = RAND.nextDouble() * 2.0 * Math.PI;
        double d8 = Math.cos(d7) * d6;
        double d9 = Math.sin(d7) * d6;
        this.setPosition(d8 + point2D.getX(), d9 + point2D.getY());
    }

    public void tunnelOut(Point2D point2D, double d) {
        assert (this._tunnelingState == 0);
        double d2 = RAND.nextBoolean() ? 1.0471975511965976 + RAND.nextDouble() * Math.PI / 3.0 : 4.1887902047863905 + RAND.nextDouble() * Math.PI / 3.0;
        double d3 = Math.sin(d2) * d;
        double d4 = Math.cos(d2) * d;
        this.setPosition(d3 + point2D.getX(), d4 + point2D.getY());
        double d5 = 0.75 * Math.sin(d2);
        double d6 = 0.75 * Math.cos(d2);
        this.setVelocity(d5, d6);
        this.setAcceleration(0.3 * d5, 0.3 * d6);
        this._tunnelingState = 1;
    }

    public void moveOut() {
        if (this._tunnelingState != 1) {
            return;
        }
        if (Point2D.distance(0.0, 0.0, this.getPosition().x, this.getPosition().y) > 1000.0) {
            this._tunnelingState = 2;
            return;
        }
        this.translate();
    }

    public void resetTunneling() {
        if (this._tunnelingState == 0) {
            return;
        }
        this.setPosition(0.0, 0.0);
        this._tunnelingState = 0;
    }
}

