/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.view.IZoomable;
import edu.colorado.phet.neuron.view.ZoomListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ZoomControl
extends PNode {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color FILL_COLOR = Color.WHITE;
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final Font SYMBOL_FONT = new PhetFont(14, true);
    private static final Color SYMBOL_COLOR = Color.BLUE;
    private static final Stroke TICK_MARK_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_MARK_COLOR = Color.LIGHT_GRAY;
    private double minZoom;
    private double maxZoom;
    private double buttonZoomAmt;
    private IZoomable zoomable;
    private PNode zoomInButton;
    private PNode zoomOutButton;
    private double sliderTrackHeight;
    private PNode sliderTrack;
    private double sliderKnobHeight;
    private PNode sliderKnob;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomFactorChanged() {
            ZoomControl.this.updateSliderKnobPosition();
        }
    };

    public ZoomControl(Dimension2D dimension2D, IZoomable iZoomable, double d, double d2, int n) {
        this.zoomable = iZoomable;
        this.minZoom = d;
        this.maxZoom = d2;
        this.buttonZoomAmt = (d2 - d) / (double)n;
        iZoomable.addZoomListener(this.zoomListener);
        this.sliderTrackHeight = dimension2D.getHeight() - 2.0 * dimension2D.getWidth();
        double d3 = dimension2D.getWidth() * 0.25;
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d3 / 2.0, 0.0, d3, this.sliderTrackHeight);
        this.sliderTrack = new PhetPPath(double_, FILL_COLOR, STROKE, STROKE_COLOR);
        double d4 = d3 * 0.25;
        double d5 = this.sliderTrackHeight / 11.0;
        for (int i = 0; i < 10; ++i) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(-d4 / 2.0, 0.0, d4 / 2.0, 0.0), TICK_MARK_STROKE, (Paint)TICK_MARK_COLOR){};
            phetPPath.setOffset(0.0, (double)(i + 1) * d5);
            this.sliderTrack.addChild(phetPPath);
        }
        this.sliderTrack.setOffset(dimension2D.getWidth() / 2.0, dimension2D.getWidth());
        this.sliderTrack.addInputEventListener(new CursorHandler(12));
        this.sliderTrack.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                ZoomControl.this.zoomable.setZoomFactor(ZoomControl.this.trackPosToZoomFactor(pInputEvent.getPositionRelativeTo(ZoomControl.this.sliderTrack).getY()));
            }
        });
        this.addChild(this.sliderTrack);
        this.sliderKnobHeight = dimension2D.getWidth() * 0.3;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(-dimension2D.getWidth() / 2.0, -this.sliderKnobHeight / 2.0, dimension2D.getWidth(), this.sliderKnobHeight, 4.0, 4.0);
        this.sliderKnob = new PhetPPath(double_2, FILL_COLOR, STROKE, STROKE_COLOR);
        this.sliderKnob.setOffset(dimension2D.getWidth() / 2.0, 0.0);
        this.sliderKnob.addInputEventListener(new CursorHandler(8));
        this.sliderKnob.addInputEventListener(new PDragEventHandler(){

            public void drag(PInputEvent pInputEvent) {
                ZoomControl.this.handleSliderKnobDragEvent(pInputEvent);
            }
        });
        this.addChild(this.sliderKnob);
        this.zoomInButton = this.createZoomButton(dimension2D.getWidth(), '+');
        this.zoomInButton.setOffset(0.0, 0.0);
        this.zoomInButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                double d = ZoomControl.this.zoomable.getZoomFactor();
                if (d < ZoomControl.this.maxZoom) {
                    if (ZoomControl.this.maxZoom - d > ZoomControl.this.buttonZoomAmt) {
                        ZoomControl.this.zoomable.setZoomFactor(d + ZoomControl.this.buttonZoomAmt);
                    } else {
                        ZoomControl.this.zoomable.setZoomFactor(ZoomControl.this.maxZoom);
                    }
                }
            }
        });
        this.addChild(this.zoomInButton);
        this.zoomOutButton = this.createZoomButton(dimension2D.getWidth(), '-');
        this.zoomOutButton.setOffset(0.0, dimension2D.getHeight() - this.zoomOutButton.getBoundsReference().getHeight());
        this.zoomOutButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                double d = ZoomControl.this.zoomable.getZoomFactor();
                if (d > ZoomControl.this.minZoom) {
                    if (d - ZoomControl.this.minZoom > ZoomControl.this.buttonZoomAmt) {
                        ZoomControl.this.zoomable.setZoomFactor(d - ZoomControl.this.buttonZoomAmt);
                    } else {
                        ZoomControl.this.zoomable.setZoomFactor(ZoomControl.this.minZoom);
                    }
                }
            }
        });
        this.addChild(this.zoomOutButton);
        this.updateSliderKnobPosition();
    }

    private void updateSliderKnobPosition() {
        this.sliderKnob.setOffset(this.sliderKnob.getOffset().getX(), this.zoomFactorToTrackPos(this.zoomable.getZoomFactor()));
    }

    private void handleSliderKnobDragEvent(PInputEvent pInputEvent) {
        PNode pNode = pInputEvent.getPickedNode();
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
        pNode.localToParent(pDimension);
        double d = pDimension.getHeight();
        double d2 = this.zoomOutButton.getFullBoundsReference().getMinY() - this.zoomInButton.getFullBoundsReference().getMaxY();
        double d3 = -d / d2 * (this.maxZoom - this.minZoom);
        double d4 = this.zoomable.getZoomFactor() + d3;
        d4 = MathUtil.clamp(this.minZoom, d4, this.maxZoom);
        this.zoomable.setZoomFactor(d4);
    }

    private double trackPosToZoomFactor(double d) {
        double d2 = this.sliderTrackHeight - this.sliderKnobHeight / 2.0;
        double d3 = this.sliderKnobHeight / 2.0;
        d = MathUtil.clamp(d3, d, d2);
        return (d2 - d) / d2 * (this.maxZoom - this.minZoom) + this.minZoom;
    }

    private double zoomFactorToTrackPos(double d) {
        assert (d >= this.minZoom && d <= this.maxZoom);
        double d2 = this.sliderTrackHeight + this.sliderTrack.getOffset().getY() - this.sliderKnobHeight / 2.0;
        double d3 = d2 - this.sliderTrackHeight + this.sliderKnobHeight;
        return d2 - (d - this.minZoom) / (this.maxZoom - this.minZoom) * (d2 - d3);
    }

    private PNode createZoomButton(double d, char c) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d, 4.0, 4.0);
        PhetPPath phetPPath = new PhetPPath(double_, FILL_COLOR, STROKE, STROKE_COLOR);
        phetPPath.addInputEventListener(new CursorHandler(12));
        PText pText = new PText(String.valueOf(c));
        pText.setPickable(false);
        pText.setFont(SYMBOL_FONT);
        pText.setTextPaint(SYMBOL_COLOR);
        pText.setScale(d * 0.5 / pText.getFullBoundsReference().width);
        pText.setOffset(d / 2.0 - pText.getFullBoundsReference().width / 2.0, d / 2.0 - pText.getFullBoundsReference().height / 2.0);
        phetPPath.addChild(pText);
        return phetPPath;
    }
}

