/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.model.IViewableParticle;
import edu.colorado.phet.neuron.model.ParticleListenerAdapter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class ParticleNode
extends PNode {
    private static final Stroke PARTICLE_EDGE_STROKE = new BasicStroke(1.0f);
    private IViewableParticle particle;
    private ModelViewTransform2D modelViewTransform;
    private PPath representation;

    public ParticleNode(IViewableParticle iViewableParticle, ModelViewTransform2D modelViewTransform2D) {
        this.particle = iViewableParticle;
        this.modelViewTransform = modelViewTransform2D;
        iViewableParticle.addListener(new ParticleListenerAdapter(){

            public void positionChanged() {
                ParticleNode.this.updateOffset();
            }

            public void appearanceChanged() {
                ParticleNode.this.updateRepresentation();
            }
        });
        this.representation = new PhetPPath(PARTICLE_EDGE_STROKE, (Paint)Color.BLACK);
        this.addChild(this.representation);
        this.updateOffset();
        this.updateRepresentation();
    }

    private void updateOffset() {
        this.setOffset(this.modelViewTransform.modelToView(this.particle.getPosition()));
    }

    private void updateRepresentation() {
        Shape shape;
        switch (this.particle.getType()) {
            case SODIUM_ION: {
                double d = this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getRadius());
                shape = new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0);
                break;
            }
            case POTASSIUM_ION: {
                double d = this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getRadius() * 2.0) * 0.85;
                shape = new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d);
                shape = AffineTransform.getRotateInstance(0.7853981633974483).createTransformedShape(shape);
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + " - Warning: No specific shape for this particle type, defaulting to sphere.");
                double d = this.modelViewTransform.modelToViewDifferentialXDouble(this.particle.getRadius());
                shape = new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0);
            }
        }
        this.representation.setPathTo(shape);
        this.representation.setPaint(this.particle.getRepresentationColor());
        this.setTransparency((float)this.particle.getOpaqueness());
    }

    public Image toImage() {
        PPath pPath = new PPath();
        pPath.addChild(this);
        pPath.setPaint(new Color(0, 0, 0, 0));
        pPath.setStroke(null);
        double d = 2.0;
        pPath.setPathTo(new Rectangle2D.Double(this.getFullBoundsReference().x - d, this.getFullBoundsReference().y - d, this.getFullBoundsReference().width + d * 2.0 + 0.5, this.getFullBoundsReference().height + d * 2.0 + 0.5));
        return pPath.toImage();
    }
}

