/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.neuron.NeuronStrings;
import edu.colorado.phet.neuron.model.NeuronModel;
import edu.colorado.phet.neuron.view.GrippyIndentNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MembranePotentialChart
extends PNode
implements SimpleObserver {
    private final JFreeChart chart;
    private final JFreeChartNode jFreeChartNode;
    private final NeuronModel neuronModel;
    private final XYSeries dataSeries = new XYSeries((Comparable)((Object)"0"));
    private final ChartCursor chartCursor;
    private static NumberAxis xAxis;
    private static NumberAxis yAxis;
    private boolean chartIsFull = false;
    private double updateCountdownTimer = 0.0;
    private double timeIndexOfFirstDataPt = 0.0;
    private boolean pausedWhenDragStarted = false;

    public MembranePotentialChart(Dimension2D dimension2D, String string, final NeuronModel neuronModel) {
        assert (neuronModel != null);
        this.neuronModel = neuronModel;
        neuronModel.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MembranePotentialChart.this.updateChart(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                neuronModel.setModeLive();
                MembranePotentialChart.this.clearChart();
                MembranePotentialChart.this.updateChartCursorVisibility();
            }

            public void clockPaused(ClockEvent clockEvent) {
                MembranePotentialChart.this.updateChartCursorPos();
                MembranePotentialChart.this.updateChartCursorVisibility();
            }
        });
        neuronModel.addListener(new NeuronModel.Adapter(){

            public void stimulusPulseInitiated() {
                if (!MembranePotentialChart.this.neuronModel.isPotentialChartVisible()) {
                    MembranePotentialChart.this.clearChart();
                }
                neuronModel.startRecording();
            }
        });
        neuronModel.addObserver(this);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(this.dataSeries);
        this.chart = MembranePotentialChart.createXYLineChart(string, NeuronStrings.MEMBRANE_POTENTIAL_X_AXIS_LABEL, NeuronStrings.MEMBRANE_POTENTIAL_Y_AXIS_LABEL, xYSeriesCollection, PlotOrientation.VERTICAL);
        this.chart.getXYPlot().getRangeAxis().setTickLabelsVisible(true);
        this.chart.getXYPlot().getRangeAxis().setRange(-100.0, 100.0);
        this.jFreeChartNode = new JFreeChartNode(this.chart, false);
        this.jFreeChartNode.setBounds(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 25.0);
        this.jFreeChartNode.updateChartRenderingInfo();
        this.addChild(this.jFreeChartNode);
        this.chartCursor = new ChartCursor(this.jFreeChartNode);
        this.addChild(this.chartCursor);
        this.chartCursor.addInputEventListener(new PBasicInputEventHandler(){
            Point2D pressPoint;
            double pressTime;

            public void mousePressed(PInputEvent pInputEvent) {
                this.pressPoint = pInputEvent.getPositionRelativeTo(MembranePotentialChart.this);
                this.pressTime = MembranePotentialChart.this.jFreeChartNode.nodeToPlot(MembranePotentialChart.this.chartCursor.getOffset()).getX();
                MembranePotentialChart.this.pausedWhenDragStarted = neuronModel.getClock().isPaused();
                if (!MembranePotentialChart.this.pausedWhenDragStarted) {
                    neuronModel.getClock().setPaused(true);
                }
            }

            public Point2D localToPlotDifferential(double d, double d2) {
                Point2D point2D = new Point2D.Double(0.0, 0.0);
                Point2D point2D2 = new Point2D.Double(d, d2);
                MembranePotentialChart.this.localToGlobal(point2D);
                MembranePotentialChart.this.localToGlobal(point2D2);
                MembranePotentialChart.this.jFreeChartNode.globalToLocal(point2D);
                MembranePotentialChart.this.jFreeChartNode.globalToLocal(point2D2);
                point2D = MembranePotentialChart.this.jFreeChartNode.nodeToPlot(point2D);
                point2D2 = MembranePotentialChart.this.jFreeChartNode.nodeToPlot(point2D2);
                return new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                if (!neuronModel.isPlayback()) {
                    neuronModel.setPlayback(1.0);
                }
                Point2D point2D = pInputEvent.getPositionRelativeTo(MembranePotentialChart.this);
                Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.pressPoint.getX(), point2D.getY() - this.pressPoint.getY());
                Point2D point2D2 = this.localToPlotDifferential(((Point2D)double_).getX(), ((Point2D)double_).getY());
                double d = this.pressTime + point2D2.getX();
                d = MathUtil.clamp(0.0, d, MembranePotentialChart.this.getLastTimeValue());
                double d2 = d / 1000.0 + neuronModel.getMinRecordedTime();
                neuronModel.setTime(d2);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (!MembranePotentialChart.this.pausedWhenDragStarted) {
                    neuronModel.getClock().setPaused(false);
                }
            }
        });
        ImageIcon imageIcon = new ImageIcon(PhetCommonResources.getInstance().getImage("buttons/closeButton.png"));
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                neuronModel.setPotentialChartVisible(false);
            }
        });
        PSwing pSwing = new PSwing(jButton);
        pSwing.setOffset(dimension2D.getWidth() - (double)jButton.getBounds().width - 2.0, 2.0);
        pSwing.addInputEventListener(new CursorHandler(12));
        this.addChild(pSwing);
        JButton jButton2 = new JButton(NeuronStrings.MEMBRANE_POTENTIAL_CLEAR_CHART);
        jButton2.setFont(new PhetFont(14));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (neuronModel.isActionPotentialInProgress()) {
                    neuronModel.startRecording();
                } else if (neuronModel.isRecord()) {
                    neuronModel.setModeLive();
                }
                MembranePotentialChart.this.clearChart();
            }
        });
        PSwing pSwing2 = new PSwing(jButton2);
        pSwing2.setOffset(pSwing.getFullBoundsReference().getMinX() - pSwing2.getFullBoundsReference().width - 10.0, 0.0);
        this.addChild(pSwing2);
        this.updateChartCursorVisibility();
        this.updateChartCursorPos();
    }

    private void addDataPoint(double d, double d2, boolean bl) {
        if (this.dataSeries.getItemCount() == 0) {
            this.timeIndexOfFirstDataPt = d;
        }
        assert (d - this.timeIndexOfFirstDataPt >= 0.0);
        if (d - this.timeIndexOfFirstDataPt <= 25.0) {
            this.dataSeries.add(d - this.timeIndexOfFirstDataPt, d2 * 1000.0, bl);
            this.chartIsFull = false;
        } else if (!this.chartIsFull) {
            this.dataSeries.add(d - this.timeIndexOfFirstDataPt, d2 * 1000.0, true);
            this.chartIsFull = true;
        } else {
            System.out.println(this.getClass().getName() + " Warning: Attempt to add data to full chart, ignoring.");
        }
    }

    private double getLastTimeValue() {
        double d = 0.0;
        if (this.dataSeries.getItemCount() > 0) {
            d = this.dataSeries.getX(this.dataSeries.getItemCount() - 1).doubleValue();
        }
        return d;
    }

    private static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        xAxis = new NumberAxis(string2);
        xAxis.setLabelFont(new PhetFont(18));
        yAxis = new NumberAxis(string3);
        yAxis.setLabelFont(new PhetFont(18));
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setStroke(new BasicStroke(3.0f, 1, 2));
        return jFreeChart;
    }

    private void updateChart(ClockEvent clockEvent) {
        if (this.neuronModel.isRecord()) {
            if (!this.chartIsFull && clockEvent.getSimulationTimeChange() > 0.0) {
                this.updateCountdownTimer -= clockEvent.getSimulationTimeChange();
                double d = this.neuronModel.getTime() * 1000.0;
                if (this.updateCountdownTimer <= 0.0) {
                    this.addDataPoint(d, this.neuronModel.getMembranePotential(), true);
                    this.updateCountdownTimer = 4.88888888888889E-5;
                } else {
                    this.addDataPoint(d, this.neuronModel.getMembranePotential(), false);
                }
            }
            if (this.chartIsFull && this.neuronModel.isRecord()) {
                this.neuronModel.setModeLive();
            }
        }
    }

    private void clearChart() {
        this.dataSeries.clear();
        this.chartIsFull = false;
        this.neuronModel.clearHistory();
        this.updateChartCursorVisibility();
    }

    private void updateChartCursorVisibility() {
        double d = (this.neuronModel.getTime() - this.neuronModel.getMinRecordedTime()) * 1000.0;
        boolean bl = d >= 0.0 && d <= 25.0;
        boolean bl2 = this.dataSeries.getItemCount() > 0;
        boolean bl3 = bl && bl2;
        this.chartCursor.setVisible(bl3);
    }

    private void moveChartCursorToTime(double d) {
        Point2D point2D = this.jFreeChartNode.plotToNode(new Point2D.Double(d, this.jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound()));
        this.chartCursor.setOffset(point2D);
    }

    private void updateChartCursorPos() {
        double d = this.neuronModel.getMinRecordedTime();
        double d2 = this.neuronModel.getTime();
        this.moveChartCursorToTime((d2 - d) * 1000.0);
    }

    public void update() {
        this.updateChartCursorVisibility();
        if (this.chartCursor.getVisible()) {
            this.updateChartCursorPos();
        }
    }

    private static class ChartCursor
    extends PPath {
        private static final Color FILL_COLOR = new Color(50, 50, 200, 80);
        private static final Color STROKE_COLOR = Color.DARK_GRAY;
        private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 5.0f}, 0.0f);

        public ChartCursor(JFreeChartNode jFreeChartNode) {
            this.setStroke(STROKE);
            this.setStrokePaint(STROKE_COLOR);
            this.setPaint(FILL_COLOR);
            Point2D point2D = jFreeChartNode.plotToNode(new Point2D.Double(0.0, jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound()));
            Point2D point2D2 = jFreeChartNode.plotToNode(new Point2D.Double(0.0, jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getLowerBound()));
            double d = jFreeChartNode.getFullBoundsReference().width * 0.013;
            double d2 = point2D2.getY() - point2D.getY();
            this.setPathTo(new Rectangle2D.Double(-d / 2.0, 0.0, d, d2));
            double d3 = 0.05 * d2;
            GrippyIndentNode grippyIndentNode = new GrippyIndentNode(d / 2.0, FILL_COLOR);
            grippyIndentNode.setOffset(0.0, d2 / 2.0 - d3);
            this.addChild(grippyIndentNode);
            GrippyIndentNode grippyIndentNode2 = new GrippyIndentNode(d / 2.0, FILL_COLOR);
            grippyIndentNode2.setOffset(0.0, d2 / 2.0);
            this.addChild(grippyIndentNode2);
            GrippyIndentNode grippyIndentNode3 = new GrippyIndentNode(d / 2.0, FILL_COLOR);
            grippyIndentNode3.setOffset(0.0, d2 / 2.0 + d3);
            this.addChild(grippyIndentNode3);
            this.addInputEventListener(new CursorHandler(11));
        }
    }
}

