/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.model.MembraneChannel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class MembraneChannelNode
extends PNode {
    private MembraneChannel membraneChannelModel;
    private ModelViewTransform2D mvt;
    private PNode channelLayer;
    private PNode edgeLayer;
    private PPath channel;
    private PPath leftEdgeNode;
    private PPath rightEdgeNode;
    private PNode inactivationGateBallNode;
    private PPath inactivationGateString;

    public MembraneChannelNode(MembraneChannel membraneChannel, ModelViewTransform2D modelViewTransform2D) {
        this.membraneChannelModel = membraneChannel;
        this.mvt = modelViewTransform2D;
        membraneChannel.addListener(new MembraneChannel.Adapter(){

            public void opennessChanged() {
                MembraneChannelNode.this.updateRepresentation();
            }

            public void inactivationAmtChanged() {
                MembraneChannelNode.this.updateRepresentation();
            }

            public void positionChanged() {
                MembraneChannelNode.this.updateLocation();
            }
        });
        this.channel = new PhetPPath(membraneChannel.getChannelColor());
        double d = (membraneChannel.getOverallSize().getWidth() - membraneChannel.getChannelSize().getWidth()) / 2.0;
        double d2 = membraneChannel.getOverallSize().getHeight();
        PDimension pDimension = new PDimension(Math.abs(modelViewTransform2D.modelToViewDifferentialXDouble(d)), Math.abs(modelViewTransform2D.modelToViewDifferentialYDouble(d2)));
        this.leftEdgeNode = this.createEdgeNode(pDimension, membraneChannel.getEdgeColor());
        this.rightEdgeNode = this.createEdgeNode(pDimension, membraneChannel.getEdgeColor());
        this.channelLayer = new PNode();
        this.addChild(this.channelLayer);
        this.channelLayer.addChild(this.channel);
        this.edgeLayer = new PNode();
        this.addChild(this.edgeLayer);
        this.edgeLayer.addChild(this.leftEdgeNode);
        this.edgeLayer.addChild(this.rightEdgeNode);
        if (membraneChannel.getHasInactivationGate()) {
            this.inactivationGateString = new PhetPPath(new BasicStroke(2.0f), (Paint)Color.BLACK);
            this.channelLayer.addChild(this.inactivationGateString);
            double d3 = modelViewTransform2D.modelToViewDifferentialXDouble(membraneChannel.getChannelSize().getWidth());
            Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3);
            this.inactivationGateBallNode = new PhetPPath(double_, ColorUtils.darkerColor(membraneChannel.getEdgeColor(), 0.3), new BasicStroke(1.0f), ColorUtils.darkerColor(membraneChannel.getEdgeColor(), 0.3));
            this.edgeLayer.addChild(this.inactivationGateBallNode);
        }
        this.updateRepresentation();
        this.updateLocation();
    }

    public void addToCanvas(PNode pNode, PNode pNode2) {
        pNode.addChild(this.channelLayer);
        pNode2.addChild(this.edgeLayer);
    }

    private PPath createEdgeNode(Dimension2D dimension2D, Color color) {
        GeneralPath generalPath = new GeneralPath();
        float f = (float)dimension2D.getWidth();
        float f2 = (float)dimension2D.getHeight();
        generalPath.moveTo(-f / 2.0f, f2 / 4.0f);
        generalPath.curveTo(-f / 2.0f, f2 / 2.0f, f / 2.0f, f2 / 2.0f, f / 2.0f, f2 / 4.0f);
        generalPath.lineTo(f / 2.0f, -f2 / 4.0f);
        generalPath.curveTo(f / 2.0f, -f2 / 2.0f, -f / 2.0f, -f2 / 2.0f, -f / 2.0f, -f2 / 4.0f);
        generalPath.closePath();
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(color);
        pPath.setStrokePaint(ColorUtils.darkerColor(color, 0.3));
        return pPath;
    }

    private void updateLocation() {
        this.channelLayer.setOffset(this.mvt.modelToViewDouble(this.membraneChannelModel.getCenterLocation()));
        this.edgeLayer.setOffset(this.mvt.modelToViewDouble(this.membraneChannelModel.getCenterLocation()));
    }

    private void updateRepresentation() {
        double d = this.membraneChannelModel.getChannelSize().getWidth() * this.membraneChannelModel.getOpenness();
        PDimension pDimension = new PDimension(d, this.membraneChannelModel.getChannelSize().getHeight());
        PDimension pDimension2 = new PDimension(Math.abs(this.mvt.modelToViewDifferentialXDouble(((Dimension2D)pDimension).getWidth())), Math.abs(this.mvt.modelToViewDifferentialYDouble(((Dimension2D)pDimension).getHeight())));
        float f = 1.1f;
        float f2 = (float)((Dimension2D)pDimension2).getWidth() * f;
        float f3 = (float)((Dimension2D)pDimension2).getHeight() * f;
        float f4 = (float)this.leftEdgeNode.getFullBoundsReference().width;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.quadTo((f2 + f4) / 2.0f, f3 / 8.0f, f2 + f4, 0.0f);
        generalPath.lineTo(f2 + f4, f3);
        generalPath.quadTo((f2 + f4) / 2.0f, f3 * 7.0f / 8.0f, 0.0f, f3);
        generalPath.closePath();
        this.channel.setPathTo(generalPath);
        this.channel.setOffset(-this.channel.getFullBoundsReference().width / 2.0, -this.channel.getFullBoundsReference().height / 2.0);
        this.leftEdgeNode.setOffset(-((Dimension2D)pDimension2).getWidth() / 2.0 - this.leftEdgeNode.getFullBoundsReference().width / 2.0, 0.0);
        this.rightEdgeNode.setOffset(((Dimension2D)pDimension2).getWidth() / 2.0 + this.rightEdgeNode.getFullBoundsReference().width / 2.0, 0.0);
        if (this.membraneChannelModel.getHasInactivationGate()) {
            PDimension pDimension3 = new PDimension(this.mvt.modelToViewDifferentialXDouble(this.membraneChannelModel.getOverallSize().getWidth()), this.mvt.modelToViewDifferentialYDouble(this.membraneChannelModel.getOverallSize().getHeight()));
            Point2D.Double double_ = new Point2D.Double(this.leftEdgeNode.getFullBoundsReference().getCenterX(), this.leftEdgeNode.getFullBoundsReference().getMaxY());
            Point2D.Double double_2 = new Point2D.Double(0.0, ((Dimension2D)pDimension2).getHeight() / 2.0);
            double d2 = -1.5707963267948966 * (1.0 - this.membraneChannelModel.getInactivationAmt());
            double d3 = (1.0 - this.membraneChannelModel.getInactivationAmt()) * pDimension3.getWidth() / 2.0 + this.membraneChannelModel.getInactivationAmt() * double_.distance(double_2);
            Point2D.Double double_3 = new Point2D.Double(((Point2D)double_).getX() + Math.cos(d2) * d3, ((Point2D)double_).getY() - Math.sin(d2) * d3);
            this.inactivationGateBallNode.setOffset(double_3);
            Point2D point2D = this.inactivationGateBallNode.getOffset();
            double d4 = double_2.distance(point2D);
            CubicCurve2D.Double double_4 = new CubicCurve2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_).getX() + d4 * 0.25, ((Point2D)double_).getY() + d4 * 0.5, point2D.getX() - d4 * 0.75, point2D.getY() - d4 * 0.5, point2D.getX(), point2D.getY());
            this.inactivationGateString.setPathTo(double_4);
        }
        this.channelLayer.setRotation(-this.membraneChannelModel.getRotationalAngle() + 1.5707963267948966);
        this.edgeLayer.setRotation(-this.membraneChannelModel.getRotationalAngle() + 1.5707963267948966);
    }
}

