/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.neuron.model.AxonMembrane;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AxonBodyNode
extends PNode {
    private static final Color AXON_BODY_COLOR = new Color(221, 216, 44);
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private AxonMembrane axonMembraneModel;
    private ModelViewTransform2D mvt;
    private PhetPPath axonBody;
    private TravelingActionPotentialNode travelingActionPotentialNode;

    public AxonBodyNode(AxonMembrane axonMembrane, ModelViewTransform2D modelViewTransform2D) {
        this.axonMembraneModel = axonMembrane;
        this.mvt = modelViewTransform2D;
        axonMembrane.addListener(new AxonMembrane.Adapter(){

            public void travelingActionPotentialStarted() {
                AxonBodyNode.this.addTravelingActionPotentialNode(AxonBodyNode.this.axonMembraneModel.getTravelingActionPotential());
            }

            public void travelingActionPotentialEnded() {
                AxonBodyNode.this.removeTravelingActionPotentialNode();
            }
        });
        Shape shape = this.mvt.createTransformedShape(axonMembrane.getAxonBodyShape());
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D rectangle2D2 = this.mvt.createTransformedShape(axonMembrane.getCrossSectionEllipseShape()).getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        Point2D.Double double_2 = new Point2D.Double(rectangle2D2.getCenterX(), rectangle2D2.getY());
        GradientPaint gradientPaint = new GradientPaint(double_, ColorUtils.darkerColor(AXON_BODY_COLOR, 0.5), double_2, ColorUtils.brighterColor(AXON_BODY_COLOR, 0.2));
        this.axonBody = new PhetPPath(shape, gradientPaint, STROKE, Color.BLACK);
        this.addChild(this.axonBody);
    }

    private void addTravelingActionPotentialNode(AxonMembrane.TravelingActionPotential travelingActionPotential) {
        this.travelingActionPotentialNode = new TravelingActionPotentialNode(travelingActionPotential, this.mvt);
        this.addChild(this.travelingActionPotentialNode);
    }

    private void removeTravelingActionPotentialNode() {
        this.removeChild(this.travelingActionPotentialNode);
        this.travelingActionPotentialNode = null;
    }

    private static class TravelingActionPotentialNode
    extends PNode {
        private static Color BACKGROUND_COLOR = new Color(204, 102, 255);
        private static Stroke backgroundStroke = new BasicStroke(20.0f, 1, 1);
        private static Color FOREGROUND_COLOR = Color.YELLOW;
        private static Stroke foregroundStroke = new BasicStroke(10.0f, 1, 1);
        private AxonMembrane.TravelingActionPotential travelingActionPotential;
        private ModelViewTransform2D mvt;
        private PhetPPath background = new PhetPPath(backgroundStroke, (Paint)BACKGROUND_COLOR);
        private PhetPPath foreground = new PhetPPath(foregroundStroke, (Paint)FOREGROUND_COLOR);

        public TravelingActionPotentialNode(AxonMembrane.TravelingActionPotential travelingActionPotential, ModelViewTransform2D modelViewTransform2D) {
            this.addChild(this.background);
            this.addChild(this.foreground);
            this.travelingActionPotential = travelingActionPotential;
            this.mvt = modelViewTransform2D;
            travelingActionPotential.addListener(new AxonMembrane.TravelingActionPotential.Adapter(){

                public void shapeChanged() {
                    TravelingActionPotentialNode.this.updateShape();
                }
            });
            this.updateShape();
        }

        private void updateShape() {
            this.foreground.setPathTo(this.mvt.createTransformedShape(this.travelingActionPotential.getShape()));
            this.background.setPathTo(this.mvt.createTransformedShape(this.travelingActionPotential.getShape()));
        }
    }
}

