/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.MotionStrategy;
import edu.colorado.phet.neuron.model.TimedFadeAwayStrategy;
import java.awt.geom.Point2D;
import java.util.Random;

public class WanderAwayThenFadeMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private final Point2D awayPoint;
    private double motionUpdateCountdownTimer;
    private double velocityUpdateCountdownTimer;
    private double preFadeCountdownTimer;
    private double fadeOutDuration;
    private Vector2D velocity = new Vector2D();

    public WanderAwayThenFadeMotionStrategy(Point2D point2D, Point2D point2D2, double d, double d2) {
        this.awayPoint = point2D;
        this.preFadeCountdownTimer = d;
        this.fadeOutDuration = d2;
        this.motionUpdateCountdownTimer = (double)RAND.nextInt(5) * 4.88888888888889E-5;
        this.velocityUpdateCountdownTimer = (double)RAND.nextInt(50) * 4.88888888888889E-5;
        this.updateVelocity(point2D2);
    }

    public void move(IMovable iMovable, IFadable iFadable, double d) {
        this.motionUpdateCountdownTimer -= d;
        if (this.motionUpdateCountdownTimer <= 0.0) {
            iMovable.setPosition(iMovable.getPositionReference().getX() + this.velocity.getX() * 2.444444444444445E-4, iMovable.getPositionReference().getY() + this.velocity.getY() * 2.444444444444445E-4);
            this.motionUpdateCountdownTimer = 2.444444444444445E-4;
        }
        this.velocityUpdateCountdownTimer -= d;
        if (this.velocityUpdateCountdownTimer <= 0.0) {
            this.updateVelocity(iMovable.getPositionReference());
            this.velocityUpdateCountdownTimer = 0.002444444444444445;
        }
        if (this.preFadeCountdownTimer >= 0.0) {
            this.preFadeCountdownTimer -= d;
            if (this.preFadeCountdownTimer <= 0.0) {
                iFadable.setFadeStrategy(new TimedFadeAwayStrategy(this.fadeOutDuration));
            }
        }
    }

    private void updateVelocity(Point2D point2D) {
        double d = Math.atan2(point2D.getY() - this.awayPoint.getY(), point2D.getX() - this.awayPoint.getX()) + (RAND.nextDouble() - 0.5) * Math.PI;
        double d2 = 500.0 + RAND.nextDouble() * 4500.0;
        this.velocity.setComponents(d2 * Math.cos(d), d2 * Math.sin(d));
    }
}

