/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.MotionStrategy;

public class SpeedChangeLinearMotionStrategy
extends MotionStrategy {
    private Vector2D velocityVector = new Vector2D();
    private double firstSpeedCountdownTimer = 0.0;
    private final double speedScaleFactor;

    public SpeedChangeLinearMotionStrategy(Vector2D vector2D, double d, double d2) {
        this.velocityVector.setComponents(vector2D.getX(), vector2D.getY());
        this.speedScaleFactor = d;
        this.firstSpeedCountdownTimer = d2;
    }

    public void move(IMovable iMovable, IFadable iFadable, double d) {
        iMovable.setPosition(iMovable.getPosition().getX() + this.velocityVector.getX() * d, iMovable.getPosition().getY() + this.velocityVector.getY() * d);
        if (this.firstSpeedCountdownTimer > 0.0) {
            this.firstSpeedCountdownTimer -= d;
            if (this.firstSpeedCountdownTimer <= 0.0) {
                this.velocityVector.scale(this.speedScaleFactor);
            }
        }
    }
}

