/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.model.AbstractLeakChannel;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PieSliceShapedCaptureZone;
import edu.colorado.phet.neuron.utils.MathUtils;
import java.awt.Color;

public class SodiumLeakageChannel
extends AbstractLeakChannel {
    private static final Color BASE_COLOR = ColorUtils.interpolateRBGA(NeuronConstants.SODIUM_COLOR, Color.YELLOW, 0.5);
    private IHodgkinHuxleyModel hodgkinHuxleyModel;
    private double previousNormalizedLeakCurrent = 0.0;

    public SodiumLeakageChannel(IParticleCapture iParticleCapture, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(2.0, 4.8, iParticleCapture);
        this.hodgkinHuxleyModel = iHodgkinHuxleyModel;
        this.setParticleVelocity(7000.0);
        this.setExteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, 0.0, 1.8849555921538759));
        this.setInteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, Math.PI, 2.5132741228718345));
        this.updateParticleCaptureRate(0.005);
        this.restartCaptureCountdownTimer(false);
    }

    public SodiumLeakageChannel() {
        this(null, null);
    }

    public Color getChannelColor() {
        return ColorUtils.darkerColor(BASE_COLOR, 0.15);
    }

    public Color getEdgeColor() {
        return BASE_COLOR;
    }

    protected ParticleType getParticleTypeToCapture() {
        return ParticleType.SODIUM_ION;
    }

    protected MembraneCrossingDirection chooseCrossingDirection() {
        MembraneCrossingDirection membraneCrossingDirection = MembraneCrossingDirection.OUT_TO_IN;
        if (this.previousNormalizedLeakCurrent == 0.0 && RAND.nextDouble() < 0.2) {
            membraneCrossingDirection = MembraneCrossingDirection.IN_TO_OUT;
        }
        return membraneCrossingDirection;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        double d2 = MathUtils.round(this.hodgkinHuxleyModel.get_l_current() / 3.44, 2);
        if (d2 <= 0.01 && (d2 = Math.max(d2, -1.0)) != this.previousNormalizedLeakCurrent) {
            this.previousNormalizedLeakCurrent = d2;
            this.updateParticleCaptureRate(Math.max(Math.abs(d2), 0.005));
        }
    }

    private void updateParticleCaptureRate(double d) {
        if (d <= 0.001) {
            this.setMinInterCaptureTime(Double.POSITIVE_INFINITY);
            this.setMaxInterCaptureTime(Double.POSITIVE_INFINITY);
            this.restartCaptureCountdownTimer(false);
        } else {
            double d2 = 2.0E-4;
            double d3 = 0.002;
            double d4 = 0.005;
            double d5 = d2 + (1.0 - d) * d3;
            this.setMinInterCaptureTime(d5);
            this.setMaxInterCaptureTime(d5 + (1.0 - d) * d4);
            if (this.getCaptureCountdownTimer() > this.getMaxInterCaptureTime()) {
                this.restartCaptureCountdownTimer(false);
            }
        }
    }
}

