/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.model.AbstractLeakChannel;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PieSliceShapedCaptureZone;
import java.awt.Color;

public class PotassiumLeakageChannel
extends AbstractLeakChannel {
    private static final Color BASE_COLOR = ColorUtils.interpolateRBGA(NeuronConstants.POTASSIUM_COLOR, new Color(0, 200, 255), 0.6);

    public PotassiumLeakageChannel(IParticleCapture iParticleCapture, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(2.0, 4.8, iParticleCapture);
        this.setParticleVelocity(5000.0);
        this.setInteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, Math.PI, 1.5707963267948966));
        this.setExteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, 0.0, 1.5707963267948966));
        this.setMinInterCaptureTime(0.002);
        this.setMaxInterCaptureTime(0.004);
        this.restartCaptureCountdownTimer(false);
    }

    public PotassiumLeakageChannel() {
        this(null, null);
    }

    public Color getChannelColor() {
        return ColorUtils.darkerColor(BASE_COLOR, 0.2);
    }

    public Color getEdgeColor() {
        return BASE_COLOR;
    }

    protected ParticleType getParticleTypeToCapture() {
        return ParticleType.POTASSIUM_ION;
    }

    protected MembraneCrossingDirection chooseCrossingDirection() {
        MembraneCrossingDirection membraneCrossingDirection = MembraneCrossingDirection.IN_TO_OUT;
        if (RAND.nextDouble() < 0.2) {
            membraneCrossingDirection = MembraneCrossingDirection.OUT_TO_IN;
        }
        return membraneCrossingDirection;
    }
}

