/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.model.GatedChannel;
import edu.colorado.phet.neuron.model.IHodgkinHuxleyModel;
import edu.colorado.phet.neuron.model.IParticleCapture;
import edu.colorado.phet.neuron.model.MembraneCrossingDirection;
import edu.colorado.phet.neuron.model.ParticleType;
import edu.colorado.phet.neuron.model.PieSliceShapedCaptureZone;
import edu.colorado.phet.neuron.utils.MathUtils;
import java.awt.Color;

public class PotassiumGatedChannel
extends GatedChannel {
    private IHodgkinHuxleyModel hodgkinHuxleyModel;
    private double staggerDelay = RAND.nextDouble() * 2.2222222222222223E-4;

    public PotassiumGatedChannel(IParticleCapture iParticleCapture, IHodgkinHuxleyModel iHodgkinHuxleyModel) {
        super(2.0, 4.8, iParticleCapture);
        this.hodgkinHuxleyModel = iHodgkinHuxleyModel;
        this.setInteriorCaptureZone(new PieSliceShapedCaptureZone(this.getCenterLocation(), 10.0, Math.PI, 1.5707963267948966));
        this.reset();
    }

    public PotassiumGatedChannel() {
        this(null, null);
    }

    public Color getChannelColor() {
        return ColorUtils.darkerColor(NeuronConstants.POTASSIUM_COLOR, 0.2);
    }

    public Color getEdgeColor() {
        return NeuronConstants.POTASSIUM_COLOR;
    }

    public void reset() {
        super.reset();
        this.setMinInterCaptureTime(5.0E-5);
        this.setMaxInterCaptureTime(2.0E-4);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        double d2 = Math.min(Math.abs(this.hodgkinHuxleyModel.get_delayed_n4(this.staggerDelay)) / 0.35, 1.0);
        double d3 = 1.0 - Math.pow(d2 - 1.0, 2.0);
        if (d3 > 0.0 && d3 < 1.0) {
            d3 = MathUtils.round(d3, 2);
        }
        if (d3 != this.getOpenness()) {
            this.setOpenness(d3);
            if (this.isOpen() && this.getCaptureCountdownTimer() == Double.POSITIVE_INFINITY) {
                this.restartCaptureCountdownTimer(true);
            }
        }
    }

    protected ParticleType getParticleTypeToCapture() {
        return ParticleType.POTASSIUM_ION;
    }

    protected MembraneCrossingDirection chooseCrossingDirection() {
        return MembraneCrossingDirection.IN_TO_OUT;
    }
}

