/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.neuron.model.CaptureZone;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class PieSliceShapedCaptureZone
extends CaptureZone {
    private static final Random RAND = new Random();
    private Arc2D zoneShape;
    private Point2D originPoint;
    private double radius;
    private double rotationAngle;
    private final double angleOfExtent;
    private final double fixedRotationalOffset;

    public PieSliceShapedCaptureZone(Point2D point2D, double d, double d2, double d3) {
        this.originPoint = point2D;
        this.radius = d;
        this.fixedRotationalOffset = d2;
        this.angleOfExtent = d3;
        this.zoneShape = new Arc2D.Double();
        this.updateShape();
    }

    public boolean isPointInZone(Point2D point2D) {
        return this.zoneShape.contains(point2D);
    }

    public void setRotationalAngle(double d) {
        this.rotationAngle = d;
        this.updateShape();
    }

    public void setOriginPoint(Point2D point2D) {
        this.originPoint = point2D;
        this.updateShape();
    }

    public Point2D getOriginPoint() {
        return this.originPoint;
    }

    private void updateShape() {
        this.zoneShape.setArcByCenter(this.originPoint.getX(), this.originPoint.getY(), this.radius, -Math.toDegrees(this.fixedRotationalOffset + this.rotationAngle + this.angleOfExtent / 2.0), Math.toDegrees(this.angleOfExtent), 2);
    }

    public Point2D getSuggestedNewParticleLocation() {
        double d = this.rotationAngle + this.fixedRotationalOffset + (RAND.nextDouble() - 0.5) * this.angleOfExtent;
        double d2 = this.radius * 0.9;
        double d3 = this.originPoint.getX() + d2 * Math.cos(d);
        double d4 = this.originPoint.getY() + d2 * Math.sin(d);
        return new Point2D.Double(d3, d4);
    }
}

