/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.neuron.model.IFadable;
import edu.colorado.phet.neuron.model.IMovable;
import edu.colorado.phet.neuron.model.LinearMotionStrategy;
import edu.colorado.phet.neuron.model.MembraneChannel;
import edu.colorado.phet.neuron.model.MembraneTraversalMotionStrategy;
import edu.colorado.phet.neuron.model.SpeedChangeLinearMotionStrategy;
import edu.colorado.phet.neuron.model.TimedFadeAwayStrategy;
import edu.colorado.phet.neuron.model.WanderAwayThenFadeMotionStrategy;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualGateChannelTraversalMotionStrategy
extends MembraneTraversalMotionStrategy {
    private static final Random RAND = new Random();
    private Vector2D velocityVector = new Vector2D();
    private ArrayList<Point2D> traversalPoints;
    private int currentDestinationIndex = 0;
    private double maxVelocity;
    protected final MembraneChannel channel;
    private boolean bouncing = false;

    public DualGateChannelTraversalMotionStrategy(MembraneChannel membraneChannel, Point2D point2D, double d) {
        this.channel = membraneChannel;
        this.maxVelocity = d;
        this.traversalPoints = this.createTraversalPoints(membraneChannel, point2D);
        this.setCourseForCurrentTraversalPoint(point2D);
    }

    public DualGateChannelTraversalMotionStrategy(MembraneChannel membraneChannel, Point2D point2D) {
        this(membraneChannel, point2D, 40000.0);
    }

    @Override
    public void move(IMovable iMovable, IFadable iFadable, double d) {
        assert (this.currentDestinationIndex < this.traversalPoints.size());
        Point2D point2D = iMovable.getPositionReference();
        if (this.currentDestinationIndex == 0) {
            if (!this.channel.isOpen()) {
                iMovable.setMotionStrategy(new WanderAwayThenFadeMotionStrategy(this.channel.getCenterLocation(), iMovable.getPosition(), 0.0, 0.002));
                this.currentDestinationIndex = Integer.MAX_VALUE;
            } else if (point2D.distance(this.traversalPoints.get(this.currentDestinationIndex)) < this.velocityVector.getMagnitude() * d) {
                iMovable.setPosition(this.traversalPoints.get(this.currentDestinationIndex));
                ++this.currentDestinationIndex;
                this.setCourseForPoint(iMovable.getPosition(), this.traversalPoints.get(this.currentDestinationIndex), this.velocityVector.getMagnitude());
            } else {
                this.moveBasedOnCurrentVelocity(iMovable, d);
            }
        } else if (this.currentDestinationIndex == 1) {
            if (this.channel.getInactivationAmt() > 0.5 && !this.bouncing) {
                this.traversalPoints.get(2).setLocation(this.traversalPoints.get(0));
                this.bouncing = true;
            }
            if (point2D.distance(this.traversalPoints.get(this.currentDestinationIndex)) < this.velocityVector.getMagnitude() * d) {
                iMovable.setPosition(this.traversalPoints.get(this.currentDestinationIndex));
                ++this.currentDestinationIndex;
                this.setCourseForPoint(iMovable.getPosition(), this.traversalPoints.get(this.currentDestinationIndex), this.velocityVector.getMagnitude());
                if (this.bouncing) {
                    this.velocityVector.scale(0.5);
                }
            } else {
                this.moveBasedOnCurrentVelocity(iMovable, d);
            }
        } else if (this.currentDestinationIndex == 2) {
            if (point2D.distance(this.traversalPoints.get(this.currentDestinationIndex)) < this.velocityVector.getMagnitude() * d) {
                iMovable.setPosition(this.traversalPoints.get(this.currentDestinationIndex));
                this.currentDestinationIndex = Integer.MAX_VALUE;
                Vector2D vector2D = new Vector2D(this.velocityVector);
                if (this.bouncing) {
                    vector2D.rotate((RAND.nextDouble() - 0.5) * Math.PI);
                    vector2D.scale(0.3 + RAND.nextDouble() * 0.2);
                    iMovable.setMotionStrategy(new LinearMotionStrategy(vector2D));
                } else {
                    double d2;
                    double d3;
                    vector2D.scale(0.5 + RAND.nextDouble() * 0.3);
                    if (RAND.nextDouble() > 0.3) {
                        d3 = 1.2566370614359172;
                        double d4 = (1.0 - this.channel.getInactivationAmt()) * Math.PI * 0.3;
                        d2 = d3 - d4;
                    } else {
                        d3 = -1.2566370614359172;
                        double d5 = (1.0 - this.channel.getInactivationAmt()) * -Math.PI * 0.1;
                        d2 = d3 - d5;
                    }
                    vector2D.rotate(d2 + RAND.nextDouble() * (d3 - d2));
                    iMovable.setMotionStrategy(new SpeedChangeLinearMotionStrategy(vector2D, 0.2, 2.0E-4));
                }
                iFadable.setFadeStrategy(new TimedFadeAwayStrategy(0.003));
            } else {
                this.moveBasedOnCurrentVelocity(iMovable, d);
            }
        }
    }

    private void moveBasedOnCurrentVelocity(IMovable iMovable, double d) {
        iMovable.setPosition(iMovable.getPosition().getX() + this.velocityVector.getX() * d, iMovable.getPosition().getY() + this.velocityVector.getY() * d);
    }

    private ArrayList<Point2D> createTraversalPoints(MembraneChannel membraneChannel, Point2D point2D) {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D point2D2 = membraneChannel.getCenterLocation();
        double d = membraneChannel.getChannelSize().getHeight() * 0.5;
        Point2D.Double double_ = new Point2D.Double(point2D2.getX() + Math.cos(membraneChannel.getRotationalAngle()) * d, point2D2.getY() + Math.sin(membraneChannel.getRotationalAngle()) * d);
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX() - Math.cos(membraneChannel.getRotationalAngle()) * d, point2D2.getY() - Math.sin(membraneChannel.getRotationalAngle()) * d);
        Point2D.Double double_3 = new Point2D.Double(point2D2.getX() - Math.cos(membraneChannel.getRotationalAngle()) * d * 0.5, point2D2.getY() - Math.sin(membraneChannel.getRotationalAngle()) * d * 0.5);
        if (point2D.distance(double_2) < point2D.distance(double_)) {
            arrayList.add(double_2);
            arrayList.add(double_3);
            arrayList.add(double_);
        } else {
            arrayList.add(double_);
            arrayList.add(double_3);
            arrayList.add(double_2);
        }
        return arrayList;
    }

    private void setCourseForPoint(Point2D point2D, Point2D point2D2, double d) {
        this.velocityVector.setComponents(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        double d2 = this.maxVelocity / this.velocityVector.getMagnitude();
        this.velocityVector.scale(d2);
    }

    private void setCourseForCurrentTraversalPoint(Point2D point2D) {
        if (this.currentDestinationIndex < this.traversalPoints.size()) {
            Point2D point2D2 = this.traversalPoints.get(this.currentDestinationIndex);
            this.velocityVector.setComponents(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            double d = this.maxVelocity / this.velocityVector.getMagnitude();
            this.velocityVector.scale(d);
        } else if (this.channel.getHasInactivationGate()) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (RAND.nextDouble() > 0.3) {
                d3 = 1.2566370614359172;
                double d4 = (1.0 - this.channel.getInactivationAmt()) * Math.PI * 0.3;
                d2 = d3 - d4;
            } else {
                d3 = -1.2566370614359172;
                double d5 = (1.0 - this.channel.getInactivationAmt()) * -Math.PI * 0.1;
                d2 = d3 - d5;
            }
            d = d2 + RAND.nextDouble() * (d3 - d2);
            this.velocityVector.rotate(d);
        } else {
            this.velocityVector.rotate((RAND.nextDouble() - 0.5) * 2.827433388230814 * this.maxVelocity / 40000.0);
        }
    }
}

