/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.model;

public class DelayBuffer {
    private DelayElement[] delayElements;
    private int numEntries;
    private boolean filling;
    private boolean allDeltaTimesEqual = true;
    private double previousDeltaTime = -1.0;
    private int countAtThisDeltaTime = 0;
    int head;
    int tail;

    public DelayBuffer(double d, double d2) {
        this.numEntries = (int)Math.ceil(d / d2);
        this.delayElements = new DelayElement[this.numEntries];
        for (int i = 0; i < this.numEntries; ++i) {
            this.delayElements[i] = new DelayElement();
        }
        this.clear();
    }

    public void addValue(double d, double d2) {
        this.delayElements[this.head].setValueAndTime(d, d2);
        this.head = (this.head + 1) % this.numEntries;
        if (this.head == this.tail) {
            this.tail = (this.tail + 1) % this.numEntries;
            this.filling = false;
        }
        if (this.previousDeltaTime == -1.0) {
            this.previousDeltaTime = d2;
            this.countAtThisDeltaTime = 1;
        } else {
            if (Math.abs(d2 - this.previousDeltaTime) > 1.0E-15) {
                this.allDeltaTimesEqual = false;
                this.countAtThisDeltaTime = 1;
            } else if (!this.allDeltaTimesEqual) {
                ++this.countAtThisDeltaTime;
                if (this.countAtThisDeltaTime >= this.numEntries) {
                    this.allDeltaTimesEqual = true;
                }
            }
            this.previousDeltaTime = d2;
        }
    }

    public double getDelayedValue(double d) {
        double d2 = 0.0;
        if (this.previousDeltaTime <= 0.0) {
            d2 = 0.0;
        } else if (this.allDeltaTimesEqual) {
            int n = (int)Math.max(Math.round(d / this.previousDeltaTime), 1L);
            if (this.filling && n > this.head || n > this.numEntries) {
                d2 = this.delayElements[this.tail].getValue();
            } else {
                int n2 = this.head - n;
                if (n2 < 0) {
                    n2 = this.numEntries + n2;
                }
                d2 = this.delayElements[n2].getValue();
            }
        } else {
            boolean bl = false;
            int n = this.head > 0 ? this.head - 1 : this.numEntries - 1;
            double d3 = 0.0;
            while (!bl) {
                if ((d3 += this.delayElements[n].getDeltaTime()) >= d) {
                    bl = true;
                    continue;
                }
                if (n == this.tail) {
                    bl = true;
                    continue;
                }
                n = n - 1 > 0 ? n - 1 : this.numEntries - 1;
            }
            d2 = this.delayElements[n].getValue();
        }
        return d2;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
        this.previousDeltaTime = -1.0;
        this.filling = true;
    }

    private class DelayElement {
        private double value;
        private double deltaTime;

        public DelayElement(double d, double d2) {
            this.value = d;
            this.deltaTime = d2;
        }

        public DelayElement() {
            this(0.0, 0.0);
        }

        protected double getValue() {
            return this.value;
        }

        protected void setValueAndTime(double d, double d2) {
            this.value = d;
            this.deltaTime = d2;
        }

        protected double getDeltaTime() {
            return this.deltaTime;
        }
    }
}

