/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron.controlpanel;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.neuron.NeuronConstants;
import edu.colorado.phet.neuron.NeuronResources;
import edu.colorado.phet.neuron.NeuronStrings;
import edu.colorado.phet.neuron.controlpanel.IonsAndChannelsLegendPanel;
import edu.colorado.phet.neuron.model.NeuronModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class AxonCrossSectionControlPanel
extends ControlPanel {
    private NeuronModel axonModel;
    private JCheckBox showAllIonsCheckBox;
    private JCheckBox chartControlCheckbox;
    private JCheckBox showChargesCheckBox;
    private JCheckBox showConcentrationReadoutCheckBox;

    public AxonCrossSectionControlPanel(PiccoloModule piccoloModule, Frame frame, final NeuronModel neuronModel) {
        this.axonModel = neuronModel;
        neuronModel.addListener(new NeuronModel.Adapter(){

            public void potentialChartVisibilityChanged() {
                AxonCrossSectionControlPanel.this.updateChartVisibilityCheckBox();
            }

            public void chargesShownChanged() {
                AxonCrossSectionControlPanel.this.updateShowChargesCheckBox();
            }

            public void allIonsSimulatedChanged() {
                AxonCrossSectionControlPanel.this.updateShowAllIonsCheckBox();
            }

            public void stimulationLockoutStateChanged() {
                AxonCrossSectionControlPanel.this.showAllIonsCheckBox.setEnabled(!neuronModel.isStimulusInitiationLockedOut());
            }

            public void concentrationReadoutVisibilityChanged() {
                AxonCrossSectionControlPanel.this.updateShowConcentrationReadoutCheckBox();
            }
        });
        int n = NeuronResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        this.addControlFullWidth(new IonsAndChannelsLegendPanel());
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NeuronStrings.CONTROL, 1, 2, NeuronConstants.CONTROL_PANEL_TITLE_FONT, Color.GRAY);
        verticalLayoutPanel.setBorder(titledBorder);
        this.showAllIonsCheckBox = new JCheckBox(NeuronStrings.SHOW_ALL_IONS);
        this.showAllIonsCheckBox.setFont(NeuronConstants.CONTROL_PANEL_CONTROL_FONT);
        this.showAllIonsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AxonCrossSectionControlPanel.this.axonModel.setAllIonsSimulated(AxonCrossSectionControlPanel.this.showAllIonsCheckBox.isSelected());
            }
        });
        this.showAllIonsCheckBox.setAlignmentX(0.5f);
        ((Container)verticalLayoutPanel).add(this.showAllIonsCheckBox);
        this.updateShowAllIonsCheckBox();
        this.addControlFullWidth(this.createVerticalSpacingPanel(5));
        this.chartControlCheckbox = new JCheckBox(NeuronStrings.SHOW_POTENTIAL_CHART);
        this.chartControlCheckbox.setFont(NeuronConstants.CONTROL_PANEL_CONTROL_FONT);
        this.chartControlCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AxonCrossSectionControlPanel.this.axonModel.setPotentialChartVisible(AxonCrossSectionControlPanel.this.chartControlCheckbox.isSelected());
            }
        });
        this.chartControlCheckbox.setAlignmentX(0.5f);
        ((Container)verticalLayoutPanel).add(this.chartControlCheckbox);
        this.updateChartVisibilityCheckBox();
        this.addControlFullWidth(this.createVerticalSpacingPanel(5));
        this.showChargesCheckBox = new JCheckBox(NeuronStrings.SHOW_CHARGES);
        this.showChargesCheckBox.setFont(NeuronConstants.CONTROL_PANEL_CONTROL_FONT);
        this.showChargesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AxonCrossSectionControlPanel.this.axonModel.setChargesShown(AxonCrossSectionControlPanel.this.showChargesCheckBox.isSelected());
            }
        });
        this.showChargesCheckBox.setAlignmentX(0.5f);
        ((Container)verticalLayoutPanel).add(this.showChargesCheckBox);
        this.updateShowChargesCheckBox();
        this.addControlFullWidth(this.createVerticalSpacingPanel(5));
        this.showConcentrationReadoutCheckBox = new JCheckBox(NeuronStrings.SHOW_CONCENTRATIONS);
        this.showConcentrationReadoutCheckBox.setFont(NeuronConstants.CONTROL_PANEL_CONTROL_FONT);
        this.showConcentrationReadoutCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AxonCrossSectionControlPanel.this.axonModel.setConcentrationReadoutVisible(AxonCrossSectionControlPanel.this.showConcentrationReadoutCheckBox.isSelected());
            }
        });
        this.showConcentrationReadoutCheckBox.setAlignmentX(0.5f);
        ((Container)verticalLayoutPanel).add(this.showConcentrationReadoutCheckBox);
        this.updateShowConcentrationReadoutCheckBox();
        this.addControlFullWidth(verticalLayoutPanel);
        this.addControlFullWidth(this.createVerticalSpacingPanel(30));
        this.addResetAllButton(piccoloModule);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private void updateChartVisibilityCheckBox() {
        this.chartControlCheckbox.setSelected(this.axonModel.isPotentialChartVisible());
    }

    private void updateShowAllIonsCheckBox() {
        this.showAllIonsCheckBox.setSelected(this.axonModel.isAllIonsSimulated());
    }

    private void updateShowChargesCheckBox() {
        this.showChargesCheckBox.setSelected(this.axonModel.isChargesShown());
    }

    private void updateShowConcentrationReadoutCheckBox() {
        this.showConcentrationReadoutCheckBox.setSelected(this.axonModel.isConcentrationReadoutVisible());
    }
}

