/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.neuron;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.neuron.developer.HodgkinHuxleyInternalDynamicsDlg;
import edu.colorado.phet.neuron.developer.HodgkinHuxleyInternalParamsDlg;
import edu.colorado.phet.neuron.module.NeuronModule;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class NeuronApplication
extends PiccoloPhetApplication {
    private NeuronModule neuronModule;
    private HodgkinHuxleyInternalDynamicsDlg hhInternalDynamicsDlg = null;
    private JCheckBoxMenuItem hhModelDynamicsControl;
    private HodgkinHuxleyInternalParamsDlg hhInternalParamsDlg = null;
    private JCheckBoxMenuItem hhModelParamsControl;

    public NeuronApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        this.neuronModule = new NeuronModule(phetFrame);
        this.addModule(this.neuronModule);
    }

    private void initMenubar(String[] stringArray) {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        this.hhModelDynamicsControl = new JCheckBoxMenuItem("Show Internal HH Model Dynamics");
        jMenu.add(this.hhModelDynamicsControl);
        this.hhModelDynamicsControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuronApplication.this.setHHModelDynamicsWindowVisible(NeuronApplication.this.hhModelDynamicsControl.isSelected());
            }
        });
        this.hhModelParamsControl = new JCheckBoxMenuItem("Show Internal HH Model Parameters");
        jMenu.add(this.hhModelParamsControl);
        this.hhModelParamsControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NeuronApplication.this.setHHModelParamsWindowVisible(NeuronApplication.this.hhModelParamsControl.isSelected());
            }
        });
    }

    private void setHHModelDynamicsWindowVisible(boolean bl) {
        if (bl && this.hhInternalDynamicsDlg == null) {
            this.hhInternalDynamicsDlg = new HodgkinHuxleyInternalDynamicsDlg((Frame)this.getPhetFrame(), this.neuronModule.getClock(), this.neuronModule.getHodgkinHuxleyModel());
            this.hhInternalDynamicsDlg.setDefaultCloseOperation(1);
            this.hhInternalDynamicsDlg.setLocationRelativeTo(null);
            this.hhInternalDynamicsDlg.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NeuronApplication.this.hhModelDynamicsControl.setSelected(false);
                }
            });
        }
        if (this.hhInternalDynamicsDlg != null) {
            this.hhInternalDynamicsDlg.setVisible(bl);
        }
    }

    private void setHHModelParamsWindowVisible(boolean bl) {
        if (bl && this.hhInternalParamsDlg == null) {
            this.hhInternalParamsDlg = new HodgkinHuxleyInternalParamsDlg((Frame)this.getPhetFrame(), this.neuronModule.getHodgkinHuxleyModel());
            this.hhInternalParamsDlg.setDefaultCloseOperation(1);
            this.hhInternalParamsDlg.setLocationRelativeTo(null);
            this.hhInternalParamsDlg.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NeuronApplication.this.hhModelParamsControl.setSelected(false);
                }
            });
        }
        if (this.hhInternalParamsDlg != null) {
            this.hhInternalParamsDlg.setVisible(bl);
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        new PhetApplicationLauncher().launchSim(stringArray, "neuron", NeuronApplication.class);
    }
}

