/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics;

import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;

public class ReversePathIterator
implements PathIterator {
    private final int windingRule;
    private final double[] coordinates;
    private final int[] segmentTypes;
    private int coordIndex = 0;
    private int segmentIndex = 0;

    public static PathIterator getReversePathIterator(Shape shape) {
        return new ReversePathIterator(shape.getPathIterator(null));
    }

    public ReversePathIterator(PathIterator pathIterator) {
        this(pathIterator, pathIterator.getWindingRule());
    }

    public ReversePathIterator(PathIterator pathIterator, int n) {
        int n2;
        int n3;
        int n4;
        this.windingRule = n;
        double[] dArray = new double[16];
        int n5 = 0;
        int[] nArray = new int[8];
        int n6 = 0;
        boolean bl = true;
        double[] dArray2 = new double[6];
        while (!pathIterator.isDone()) {
            if (n6 == nArray.length) {
                int[] nArray2 = new int[2 * n6];
                System.arraycopy(nArray, 0, nArray2, 0, n6);
                nArray = nArray2;
            }
            int n7 = n6++;
            int n8 = pathIterator.currentSegment(dArray2);
            nArray[n7] = n8;
            n4 = n8;
            if (bl) {
                if (n4 != 0) {
                    throw new IllegalPathStateException("missing initial moveto in path definition");
                }
                bl = false;
            }
            switch (n4) {
                case 0: 
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 4;
                    break;
                }
                case 3: {
                    n3 = 6;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (n3 > 0) {
                if (n5 + n3 > dArray.length) {
                    double[] dArray3 = new double[dArray.length * 2];
                    System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
                    dArray = dArray3;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray[n5++] = dArray2[n2];
                }
            }
            pathIterator.next();
        }
        this.coordinates = new double[n5];
        for (n4 = n5 / 2 - 1; n4 >= 0; --n4) {
            this.coordinates[2 * n4] = dArray[n5 - 2 * n4 - 2];
            this.coordinates[2 * n4 + 1] = dArray[n5 - 2 * n4 - 1];
        }
        this.segmentTypes = new int[n6];
        if (n6 > 0) {
            n4 = 0;
            n3 = 0;
            this.segmentTypes[n3++] = 0;
            block12: for (n2 = n6 - 1; n2 > 0; --n2) {
                switch (nArray[n2]) {
                    case 0: {
                        if (n4 != 0) {
                            n4 = 0;
                            this.segmentTypes[n3++] = 4;
                        }
                        this.segmentTypes[n3++] = 0;
                        continue block12;
                    }
                    case 4: {
                        n4 = 1;
                        continue block12;
                    }
                    default: {
                        this.segmentTypes[n3++] = nArray[n2];
                    }
                }
            }
            if (n4 != 0) {
                this.segmentTypes[n3] = 4;
            }
        }
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    private static final int coordinatesForSegmentType(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    public void next() {
        this.coordIndex += ReversePathIterator.coordinatesForSegmentType(this.segmentTypes[this.segmentIndex++]);
    }

    public boolean isDone() {
        return this.segmentIndex >= this.segmentTypes.length;
    }

    public int currentSegment(double[] dArray) {
        int n = this.segmentTypes[this.segmentIndex];
        int n2 = ReversePathIterator.coordinatesForSegmentType(n);
        if (n2 > 0) {
            System.arraycopy(this.coordinates, this.coordIndex, dArray, 0, n2);
        }
        return n;
    }

    public int currentSegment(float[] fArray) {
        int n = this.segmentTypes[this.segmentIndex];
        int n2 = ReversePathIterator.coordinatesForSegmentType(n);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                fArray[i] = (float)this.coordinates[this.coordIndex + i];
            }
        }
        return n;
    }
}

